/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import juzu.impl.metamodel.Key;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.metamodel.MetaModelEvent;
import juzu.impl.utils.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaModelObject
implements Serializable {
    private final HashMap<Key<?>, MetaModelObject> children = new HashMap();
    private final HashMap<MetaModelObject, Key<?>> parents = new HashMap();
    private MetaModel metaModel;

    public MetaModelObject() {
        if (this instanceof MetaModel) {
            this.metaModel = (MetaModel)this;
        }
    }

    public final Collection<MetaModelObject> getParents() {
        return this.parents.keySet();
    }

    public final <O extends MetaModelObject> O getChild(Key<O> key) {
        MetaModelObject child = this.children.get(key);
        if (child != null) {
            return (O)((MetaModelObject)key.getType().cast(child));
        }
        return null;
    }

    public final Collection<MetaModelObject> getChildren() {
        return this.getChildren(MetaModelObject.class);
    }

    public final <O extends MetaModelObject> Collection<Key<O>> getKeys(Class<O> filter) {
        ArrayList<Key<O>> list = new ArrayList<Key<O>>(this.children.size());
        for (Key<?> key : this.children.keySet()) {
            if (!filter.isAssignableFrom(key.getType())) continue;
            list.add(key);
        }
        return list;
    }

    public final <O extends MetaModelObject> Collection<O> getChildren(Class<O> filter) {
        ArrayList<O> list = new ArrayList<O>(this.children.size());
        for (MetaModelObject child : this.children.values()) {
            if (!filter.isInstance(child)) continue;
            list.add(filter.cast(child));
        }
        return list;
    }

    public final <O extends MetaModelObject> O addChild(Key<O> key, O child) throws IllegalArgumentException, IllegalStateException {
        if (this.closure(child, new HashSet<MetaModelObject>()).contains(this)) {
            throw new IllegalStateException("Cycle detected");
        }
        if (child.parents.containsKey(this)) {
            throw new IllegalArgumentException("Child " + child + " cannot be added for key " + key + " because parent already contains it");
        }
        if (child.parents.size() == 0) {
            child.metaModel = this.metaModel;
            child.postConstruct();
        } else if (child.metaModel != this.metaModel) {
            throw new UnsupportedOperationException("handle me gracefully " + child.metaModel + " " + this.metaModel);
        }
        this.children.put(key, child);
        child.parents.put(this, key);
        child.postAttach(this);
        return child;
    }

    public final <O extends MetaModelObject> O removeChild(Key<O> key) {
        MetaModelObject child = this.children.remove(key);
        if (child != null) {
            if (child.parents.remove(this) != null) {
                child.preDetach(this);
                if (child.parents.isEmpty()) {
                    if (child.children.size() > 0) {
                        for (Key<?> key2 : new ArrayList(child.children.keySet())) {
                            child.removeChild(key2);
                        }
                    }
                    child.preRemove();
                    child.metaModel = null;
                }
                return (O)((MetaModelObject)key.getType().cast(child));
            }
            throw new AssertionError((Object)"Internal bug");
        }
        throw new IllegalArgumentException("The element is not child of this node");
    }

    public final void remove() {
        while (this.parents.size() > 0) {
            Iterator<Map.Entry<MetaModelObject, Key<?>>> iterator = this.parents.entrySet().iterator();
            Map.Entry<MetaModelObject, Key<?>> entry = iterator.next();
            MetaModelObject parent = entry.getKey();
            Key<?> key = entry.getValue();
            parent.removeChild(key);
        }
    }

    public void queue(MetaModelEvent event) {
        this.metaModel.queue(event);
    }

    protected void postConstruct() {
    }

    protected void preDetach(MetaModelObject parent) {
    }

    protected void postAttach(MetaModelObject parent) {
    }

    protected void preRemove() {
    }

    public boolean exist(MetaModel model) {
        return true;
    }

    public JSON toJSON() {
        return new JSON();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.toJSON() + "]";
    }

    private Set<MetaModelObject> closure(MetaModelObject node, Set<MetaModelObject> closure) {
        if (!closure.contains(node)) {
            closure.add(node);
            for (MetaModelObject child : node.children.values()) {
                this.closure(child, closure);
            }
        }
        return closure;
    }
}

