/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.utils;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import juzu.impl.utils.QN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FQN
implements Serializable,
Iterable<String> {
    private final String name;
    private final QN packageName;
    private final String simpleName;

    public FQN(Class<?> type) {
        this(type.getName());
    }

    public FQN(String name) {
        String simpleName;
        QN packageName;
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            packageName = QN.EMPTY;
            simpleName = name;
        } else {
            packageName = QN.parse(name.substring(0, pos));
            simpleName = name.substring(pos + 1);
        }
        this.name = name;
        this.packageName = packageName;
        this.simpleName = simpleName;
    }

    public FQN(CharSequence packageName, CharSequence simpleName) {
        this(((Object)packageName).toString(), ((Object)simpleName).toString());
    }

    public FQN(String packageName, String simpleName) {
        this(QN.parse(packageName), simpleName);
    }

    public FQN(QN packageName, String simpleName) {
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.name = packageName.isEmpty() ? simpleName : packageName + "." + simpleName;
    }

    public String getName() {
        return this.name;
    }

    public QN getPackageName() {
        return this.packageName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < FQN.this.packageName.size() + 1;
            }

            @Override
            public String next() {
                if (this.index < FQN.this.packageName.size()) {
                    return FQN.this.packageName.get(this.index++);
                }
                if (this.index == FQN.this.packageName.size()) {
                    ++this.index;
                    return FQN.this.simpleName;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.packageName.size() + 1;
    }

    public String get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index " + index + " cannot be negative");
        }
        if (index < this.packageName.size()) {
            return this.packageName.get(index);
        }
        if (index == this.packageName.size()) {
            return this.simpleName;
        }
        throw new IndexOutOfBoundsException("Index " + index + " cannot be greater than bound " + this.packageName.size() + 1);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FQN) {
            FQN that = (FQN)obj;
            return this.packageName.equals(that.packageName) && this.simpleName.equals(that.simpleName);
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

