/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.utils;

import java.io.Serializable;
import java.util.Iterator;
import juzu.impl.utils.FQN;
import juzu.impl.utils.QN;
import juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Path
implements Serializable,
Iterable<String> {
    private static final int PARSE_CANONICAL = 0;
    private static final int PARSE_ANY = 1;
    protected final FQN fqn;
    private String canonical;
    private String value;
    private final String ext;
    private String name;

    public static Path create(boolean absolute, QN qn, String name, String extension) {
        return absolute ? new Absolute(null, new FQN(qn, name), extension) : new Relative(null, new FQN(qn, name), extension);
    }

    public static Path parse(String path) throws NullPointerException, IllegalArgumentException {
        boolean absolute = path.length() > 0 && path.charAt(0) == '/';
        String[] atoms = Path.parse(0, 0, path, 0, 0);
        return absolute ? new Absolute(path, atoms) : new Relative(path, atoms);
    }

    private static String[] parse(int mode, int padding, String path, int off, int size) {
        int len = path.length();
        int at = padding + size;
        if (off < len) {
            int pos = path.indexOf(47, off);
            if (pos == -1) {
                int cur = path.indexOf(46, off);
                if (cur == -1) {
                    String[] ret = new String[padding + size + 2];
                    ret[at] = path.substring(off);
                    return ret;
                }
                if (cur - off < 1 || len - cur < 2) {
                    throw new IllegalArgumentException("The path " + path + " contains an illegal '.' char at the index " + cur);
                }
                int dotPos = path.indexOf(46, cur + 1);
                if (dotPos != -1) {
                    throw new IllegalArgumentException("The path " + path + " contains an illegal '.' char at the index " + dotPos);
                }
                String[] ret = new String[padding + size + 2];
                ret[at] = path.substring(off, cur);
                ret[padding + size + 1] = path.substring(cur + 1);
                return ret;
            }
            int diff = pos - off;
            if (diff == 0) {
                return Path.parse(mode, padding, path, off + 1, size);
            }
            if (diff == 1 && path.charAt(off) == '.') {
                switch (mode) {
                    case 0: {
                        throw new IllegalArgumentException("No '.' allowed here");
                    }
                    case 1: {
                        return Path.parse(mode, padding, path, off + 2, size);
                    }
                }
                throw new AssertionError((Object)"Should not be here");
            }
            if (diff == 2 && path.charAt(off) == '.' && path.charAt(off + 1) == '.') {
                switch (mode) {
                    case 0: {
                        throw new IllegalArgumentException("No '.' allowed here");
                    }
                    case 1: {
                        if (size > 0) {
                            return Path.parse(mode, padding, path, off + 3, size - 1);
                        }
                        if (padding > 0) {
                            return Path.parse(mode, padding - 1, path, off + 3, size);
                        }
                        throw new IllegalArgumentException("Invalid path");
                    }
                }
                throw new AssertionError((Object)"Should not be here");
            }
            for (int i = off; i < pos; ++i) {
                if (path.charAt(i) != '.') continue;
                throw new IllegalArgumentException("No '.' allowed here");
            }
            String[] ret = Path.parse(mode, padding, path, pos + 1, size + 1);
            if (ret[at] == null) {
                ret[at] = path.substring(off, pos);
            }
            return ret;
        }
        String[] ret = new String[padding + size + 2];
        ret[at] = "";
        return ret;
    }

    private Path(String value, FQN fqn, String ext) {
        this.fqn = fqn;
        this.canonical = null;
        this.value = value;
        this.ext = ext;
        this.name = null;
    }

    private Path(String path, String[] atoms) {
        QN qn;
        int len = atoms.length - 2;
        if (len == 0) {
            qn = QN.EMPTY;
        } else if (len == 1) {
            qn = new QN(atoms[0], atoms, 1);
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append('.');
                }
                sb.append(atoms[i]);
            }
            qn = new QN(sb.toString(), atoms, len);
        }
        this.fqn = new FQN(qn, atoms[len]);
        this.canonical = null;
        this.value = path;
        this.ext = atoms[atoms.length - 1];
        this.name = null;
    }

    public Path append(String path) throws NullPointerException, IllegalArgumentException {
        if (path == null) {
            throw new NullPointerException("No null path accepted");
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            throw new IllegalArgumentException("Cannot append absolute path " + path);
        }
        QN pkg = this.fqn.getPackageName();
        int len = pkg.size();
        String[] atoms = Path.parse(1, len, path, 0, 0);
        pkg.mergeTo(atoms);
        StringBuilder sb = new StringBuilder();
        if (this.isAbsolute()) {
            sb.append('/');
        }
        for (int i = 0; i < atoms.length - 1; ++i) {
            sb.append(atoms[i]);
        }
        String ext = atoms[atoms.length - 1];
        if (ext != null && ext.length() > 0) {
            sb.append('.').append(ext);
        }
        return this.isAbsolute() ? new Absolute(sb.toString(), atoms) : new Relative(sb.toString(), atoms);
    }

    @Override
    public Iterator<String> iterator() {
        return this.fqn.iterator();
    }

    public String getValue() {
        if (this.value == null) {
            return this.getCanonical();
        }
        return this.value;
    }

    public abstract boolean isAbsolute();

    public QN getQN() {
        return this.fqn.getPackageName();
    }

    public FQN getFQN() {
        return this.fqn;
    }

    public String getRawName() {
        return this.fqn.getSimpleName();
    }

    public String getExt() {
        return this.ext;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.ext != null ? this.fqn.getSimpleName() + "." + this.ext : this.fqn.getSimpleName();
        }
        return this.name;
    }

    public abstract Path as(String var1);

    public String getCanonical() {
        if (this.canonical == null) {
            StringBuilder sb = new StringBuilder();
            if (this.isAbsolute()) {
                sb.append('/');
            }
            for (int i = 0; i < this.fqn.size(); ++i) {
                if (i > 0) {
                    sb.append('/');
                }
                sb.append(this.fqn.get(i));
            }
            if (this.ext != null) {
                sb.append('.').append(this.ext);
            }
            this.canonical = sb.toString();
        }
        return this.canonical;
    }

    public int hashCode() {
        return this.fqn.hashCode() ^ (this.ext != null ? this.ext.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() == this.getClass()) {
            Path that = (Path)obj;
            return this.fqn.equals(that.fqn) && Tools.safeEquals(this.ext, that.ext);
        }
        return false;
    }

    public String toString() {
        return "Path[absolute=" + this.isAbsolute() + ",fqn=" + this.fqn + ",extension=" + this.ext + "]";
    }

    public static class Relative
    extends Path {
        public static Relative create(QN qn, String name, String extension) {
            return new Relative(null, new FQN(qn, name), extension);
        }

        private Relative(String value, FQN fqn, String extension) {
            super(value, fqn, extension);
        }

        private Relative(String path, String[] atoms) {
            super(path, atoms);
        }

        public Relative as(String ext) {
            return new Relative(null, this.fqn, ext);
        }

        public Relative append(String path) throws NullPointerException, IllegalArgumentException {
            return (Relative)super.append(path);
        }

        public boolean isAbsolute() {
            return false;
        }
    }

    public static class Absolute
    extends Path {
        public static Absolute create(QN qn, String rawName, String ext) {
            return new Absolute(null, new FQN(qn, rawName), ext);
        }

        private Absolute(String value, FQN fqn, String extension) {
            super(value, fqn, extension);
        }

        private Absolute(String path, String[] atoms) {
            super(path, atoms);
        }

        public Absolute as(String ext) {
            return new Absolute(null, this.fqn, ext);
        }

        public Absolute append(String path) throws NullPointerException, IllegalArgumentException {
            return (Absolute)super.append(path);
        }

        public boolean isAbsolute() {
            return true;
        }
    }
}

