/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import juzu.impl.common.FileKey;
import juzu.impl.common.Name;
import juzu.impl.common.Path;
import juzu.impl.common.Tools;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class NameTestCase
extends AbstractTestCase {
    @Test
    public void testKind() {
        Name empty = Name.parse((CharSequence)"");
        NameTestCase.assertEquals((String)"", (String)empty.toString());
        NameTestCase.assertTrue((boolean)empty.isEmpty());
        NameTestCase.assertFalse((boolean)empty.isSimple());
        NameTestCase.assertFalse((boolean)empty.isQualified());
        Name single = Name.parse((CharSequence)"foo");
        NameTestCase.assertEquals((String)"foo", (String)single.toString());
        NameTestCase.assertFalse((boolean)single.isEmpty());
        NameTestCase.assertTrue((boolean)single.isSimple());
        NameTestCase.assertFalse((boolean)single.isQualified());
        Name qualified = Name.parse((CharSequence)"foo.bar");
        NameTestCase.assertEquals((String)"foo.bar", (String)qualified.toString());
        NameTestCase.assertFalse((boolean)qualified.isEmpty());
        NameTestCase.assertFalse((boolean)qualified.isSimple());
        NameTestCase.assertTrue((boolean)qualified.isQualified());
    }

    @Test
    public void testParent() {
        Name abc = Name.parse((CharSequence)"a.b.c");
        Name ab = abc.getParent();
        NameTestCase.assertEquals((Object)Name.parse((CharSequence)"a.b"), (Object)ab);
        Name a = ab.getParent();
        NameTestCase.assertEquals((Object)a, (Object)ab.getParent());
        NameTestCase.assertEquals((Object)Name.parse((CharSequence)"a"), (Object)a);
        Name empty = a.getParent();
        NameTestCase.assertEquals((Object)Name.parse((CharSequence)""), (Object)empty);
        NameTestCase.assertEquals((int)0, (int)empty.size());
        NameTestCase.assertEquals((int)0, (int)empty.length());
        NameTestCase.assertEquals((Object)null, (Object)empty.getParent());
    }

    @Test
    public void testParse() {
        this.assertName("", new String[0]);
        this.assertName("a", "a");
        this.assertName("a.b", "a", "b");
        this.assertName("a.b.c", "a", "b", "c");
    }

    private void assertName(String test, String ... expected) {
        this.assertName(expected, "", test, "");
        this.assertName(expected, "", test, "_");
        this.assertName(expected, "", test, ".");
        this.assertName(expected, "", test, "_.");
        this.assertName(expected, "_", test, "");
        this.assertName(expected, ".", test, "");
        this.assertName(expected, "._", test, "");
    }

    private void assertName(String[] expected, String prefix, String s, String suffix) {
        Name name = this.parse(prefix, s, suffix);
        NameTestCase.assertEquals(Arrays.asList(expected), Tools.list((Iterable)name));
        NameTestCase.assertEquals((String)Tools.join((char)'.', (String[])expected), (String)name.toString());
    }

    private void assertIAE(String prefix, String s, String suffix) {
        try {
            this.parse(prefix, s, suffix);
            NameTestCase.fail((String)("Was expecting " + s + " to throw an IAE"));
        }
        catch (IllegalArgumentException ok) {
            // empty catch block
        }
    }

    private Name parse(String prefix, String s, String suffix) {
        return Name.parse((CharSequence)(prefix + s + suffix), (int)prefix.length(), (int)(prefix.length() + s.length()));
    }

    @Test
    public void testResolveDotInRawName() throws Exception {
        Name name = Name.parse((CharSequence)"foo");
        Path path = Path.parse((String)"a.b.c");
        FileKey file = name.resolve(path);
        NameTestCase.assertEquals((String)"foo", (String)file.packageFQN);
        NameTestCase.assertEquals((String)"a.b.c", (String)file.name);
        NameTestCase.assertEquals((String)"c", (String)file.ext);
        NameTestCase.assertEquals((String)"a.b", (String)file.rawName);
        NameTestCase.assertEquals((String)"foo.a.b", (String)file.fqn);
    }

    @Test
    public void testResolveUp() throws Exception {
        Name name = Name.parse((CharSequence)"foo.bar");
        FileKey file = name.resolve("../juu/daa.txt");
        NameTestCase.assertEquals((String)"foo.juu", (String)file.packageFQN);
        NameTestCase.assertEquals((String)"daa.txt", (String)file.name);
        NameTestCase.assertEquals((String)"txt", (String)file.ext);
        NameTestCase.assertEquals((String)"daa", (String)file.rawName);
        NameTestCase.assertEquals((String)"foo.juu.daa", (String)file.fqn);
    }

    @Test
    public void testIAE() {
        this.assertIAE(".");
        this.assertIAE(".a");
        this.assertIAE("a.");
        this.assertIAE("a..b");
        this.assertIAE("ab..c");
    }

    private void assertIAE(String value) {
        try {
            Name.parse((CharSequence)value);
            NameTestCase.fail((String)("Was expecting " + value + " to fail"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testValues() {
        this.assertQN("a.b", "a", "b");
        this.assertQN("a.b.c", "a", "b", "c");
    }

    private void assertQN(String value, String ... names) {
        Name qn = Name.parse((CharSequence)value);
        ArrayList testNames = Tools.list((Iterable)qn);
        NameTestCase.assertEquals(Arrays.asList(names), testNames);
        NameTestCase.assertEquals((String)value, (String)qn.toString());
    }

    @Test
    public void testEmpty() {
        Name empty = Name.parse((CharSequence)"");
        NameTestCase.assertEquals((int)0, (int)empty.size());
        NameTestCase.assertEquals((int)0, (int)empty.length());
        NameTestCase.assertEquals(Collections.emptyList(), Tools.list((Iterable)empty));
        NameTestCase.assertNull((Object)empty.getParent());
        NameTestCase.assertEquals((String)"", (String)empty.toString());
    }

    @Test
    public void testSimple() {
        Name simple = Name.parse((CharSequence)"a");
        NameTestCase.assertEquals((int)1, (int)simple.size());
        NameTestCase.assertEquals((int)1, (int)simple.length());
        NameTestCase.assertEquals(Collections.singletonList("a"), Tools.list((Iterable)simple));
        Name parent = simple.getParent();
        NameTestCase.assertEquals((int)0, (int)parent.size());
        NameTestCase.assertEquals((int)0, (int)parent.length());
        NameTestCase.assertEquals((String)"a", (String)simple.toString());
    }

    @Test
    public void testAppend() {
        this.assertAppend("a.b", "a", "b");
        this.assertAppend("a.b.c", "a.b", "c");
        try {
            Name.parse((CharSequence)"a").append(new String[]{""});
            NameTestCase.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Name.parse((CharSequence)"a").append(new String[]{"a.b"});
            NameTestCase.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Name.parse((CharSequence)"a").append(new String[]{null});
            NameTestCase.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Name.parse((CharSequence)"a").append((String[])null);
            NameTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void assertAppend(String expected, String qn, String simpleName) {
        Name parsed = Name.parse((CharSequence)qn);
        Name appended = parsed.append(new String[]{simpleName});
        NameTestCase.assertEquals((String)expected, (String)appended.toString());
        NameTestCase.assertEquals((int)appended.size(), (int)(parsed.size() + 1));
    }

    @Test
    public void testPrefix() {
        this.assertPrefix("", "");
        this.assertPrefix("", "a");
        this.assertPrefix("", "a.b");
        this.assertPrefix("", "a.b.c");
        this.assertNotPrefix("a", "");
        this.assertPrefix("a", "a");
        this.assertPrefix("a", "a.b");
        this.assertPrefix("a", "a.b.c");
        this.assertNotPrefix("a.b", "");
        this.assertNotPrefix("a.b", "a");
        this.assertPrefix("a.b", "a.b");
        this.assertPrefix("a.b", "a.b.c");
        this.assertNotPrefix("a.b.c", "");
        this.assertNotPrefix("a.b.c", "a");
        this.assertNotPrefix("a.b.c", "a.b");
        this.assertPrefix("a.b.c", "a.b.c");
    }

    private void assertPrefix(String prefix, String s) {
        NameTestCase.assertTrue((boolean)Name.parse((CharSequence)prefix).isPrefix(Name.parse((CharSequence)s)));
    }

    private void assertNotPrefix(String prefix, String s) {
        NameTestCase.assertFalse((boolean)Name.parse((CharSequence)prefix).isPrefix(Name.parse((CharSequence)s)));
    }

    @Test
    public void testGetPrefix() {
        NameTestCase.assertGetPrefix("a.b", "a.b", "a.b");
        NameTestCase.assertGetPrefix("a.b", "a.b.c", "a.b");
        NameTestCase.assertGetPrefix("a.b", "a.b.c", "a.b.d");
    }

    private static void assertGetPrefix(String expected, String a, String b) {
        Name actual = Name.parse((CharSequence)a).getPrefix(Name.parse((CharSequence)b));
        NameTestCase.assertEquals((String)("Was expecting common prefix between " + a + " and " + b + "  to be equals to " + expected + " instead of " + actual), (Object)Name.parse((CharSequence)expected), (Object)actual);
    }
}

