/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Matcher;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.metamodel.MetaModelEvent;
import juzu.impl.metamodel.MetaModelState;
import juzu.impl.plugin.module.metamodel.ModuleMetaModel;
import juzu.impl.plugin.template.metamodel.TemplateMetaModel;
import juzu.impl.plugin.template.metamodel.TemplateMetaModelPlugin;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import juzu.test.JavaFile;
import org.junit.Test;

public class TemplateTestCase
extends AbstractTestCase {
    @Test
    public void testTemplatePathMatching() {
        this.assertNotMatch("a");
        this.assertMatch("a.b", "", "a", "b");
        this.assertNotMatch("/a.b");
        this.assertMatch("a/b.c", "a/", "b", "c");
        this.assertNotMatch("/a/b.c");
        this.assertNotMatch("a/b");
    }

    private void assertMatch(String test, String expectedFolder, String expectedRawName, String expectedExtension) {
        Matcher matcher = TemplateMetaModelPlugin.PATH_PATTERN.matcher(test);
        TemplateTestCase.assertTrue((String)("Was expecting " + test + " to match"), (boolean)matcher.matches());
        TemplateTestCase.assertEquals((String)expectedFolder, (String)matcher.group(1));
        TemplateTestCase.assertEquals((String)expectedRawName, (String)matcher.group(2));
        TemplateTestCase.assertEquals((String)expectedExtension, (String)matcher.group(3));
    }

    private void assertNotMatch(String test) {
        Matcher matcher = TemplateMetaModelPlugin.PATH_PATTERN.matcher(test);
        TemplateTestCase.assertFalse((String)("Was not expecting " + test + " to match"), (boolean)matcher.matches());
    }

    @Test
    public void testRemoveTemplate() throws Exception {
        CompilerAssert<File, File> helper = this.compiler("metamodel.template");
        helper.assertCompile();
        TemplateTestCase.assertDelete((File)helper.getSourcePath().getPath(new String[]{"metamodel", "template", "templates", "index.gtmpl"}));
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).failCompile();
    }

    @Test
    public void testRemoveAnnotation() throws Exception {
        CompilerAssert<File, File> helper = this.compiler("metamodel.template");
        helper.assertCompile();
        JavaFile<File> file = helper.assertSource("metamodel", "template", "A.java");
        ClassOrInterfaceDeclaration a = file.assertDeclaration();
        FieldDeclaration decl = (FieldDeclaration)a.getMembers().get(0);
        decl.getAnnotations().clear();
        file.assertSave();
        File ser = (File)helper.getSourceOutput().getPath(new String[]{"juzu", "metamodel.ser"});
        MetaModelState unserialize = (MetaModelState)Tools.unserialize(MetaModelState.class, (File)ser);
        ModuleMetaModel mm = (ModuleMetaModel)unserialize.metaModel;
        mm.getQueue().clear();
        Tools.serialize((Serializable)unserialize, (File)ser);
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).assertCompile();
        unserialize = (MetaModelState)Tools.unserialize(MetaModelState.class, (File)ser);
        mm = (ModuleMetaModel)unserialize.metaModel;
        List events = mm.getQueue().clear();
        TemplateTestCase.assertEquals((int)1, (int)events.size());
        TemplateTestCase.assertEquals((int)1, (int)((MetaModelEvent)events.get(0)).getType());
        TemplateTestCase.assertInstanceOf(TemplateMetaModel.class, ((MetaModelEvent)events.get(0)).getObject());
    }
}

