/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.ajax;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import juzu.test.AbstractWebTestCase;
import juzu.test.UserAgent;
import juzu.test.protocol.http.HttpServletImpl;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;

public abstract class AbstractAjaxTestCase
extends AbstractWebTestCase {
    protected static WebArchive createDeployment(WebArchive war) {
        URL jquery = HttpServletImpl.class.getResource("jquery-1.7.1.js");
        URL test = HttpServletImpl.class.getResource("test.js");
        URL stylesheet = HttpServletImpl.class.getResource("main.css");
        return (WebArchive)((WebArchive)((WebArchive)war.addAsWebResource(jquery, "jquery.js")).addAsWebResource(test, "test.js")).addAsWebResource(stylesheet, "main.css");
    }

    @Test
    @RunAsClient
    public void testAjaxResource() throws Exception {
        UserAgent ua = this.assertInitialPage();
        HtmlPage page = ua.getHomePage();
        HtmlAnchor trigger1 = (HtmlAnchor)page.getElementById("trigger1");
        trigger1.click();
        List<String> alerts = ua.getAlerts((Page)page);
        AbstractAjaxTestCase.assertEquals(Arrays.asList("m1()"), alerts);
        HtmlAnchor trigger2 = (HtmlAnchor)page.getElementById("trigger2");
        trigger2.click();
        alerts = ua.getAlerts((Page)page);
        AbstractAjaxTestCase.assertEquals(Arrays.asList("m1()", "m2(foo)"), alerts);
        HtmlAnchor trigger3 = (HtmlAnchor)page.getElementById("trigger3");
        trigger3.click();
        alerts = ua.getAlerts((Page)page);
        AbstractAjaxTestCase.assertEquals(Arrays.asList("m1()", "m2(foo)", "m3()"), alerts);
    }
}

