/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.binding;

import java.io.File;
import java.util.List;
import juzu.impl.compiler.CompilationError;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.impl.plugin.binding.BindingMetaModelPlugin;
import juzu.test.AbstractInjectTestCase;
import juzu.test.CompilerAssert;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockRenderBridge;
import org.junit.Test;

public class BindingBeanTestCase
extends AbstractInjectTestCase {
    public BindingBeanTestCase(InjectorProvider di) {
        super(di);
    }

    @Test
    public void testCreate() throws Exception {
        MockApplication<?> app = this.application("plugin.binding.create").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        BindingBeanTestCase.assertEquals((String)"pass", (String)render.assertStringResult());
    }

    @Test
    public void testAbstractClass() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.binding.abstractclass");
        compiler.formalErrorReporting(true);
        List<CompilationError> errors = compiler.failCompile();
        BindingBeanTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        BindingBeanTestCase.assertEquals((Object)BindingMetaModelPlugin.BEAN_ABSTRACT_TYPE, (Object)error.getCode());
        File f = (File)compiler.getSourcePath().getPath(new String[]{"plugin", "binding", "abstractclass", "package-info.java"});
        BindingBeanTestCase.assertEquals((Object)f, (Object)error.getSourceFile());
    }

    @Test
    public void testNotClass() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.binding.notclass");
        compiler.formalErrorReporting(true);
        List<CompilationError> errors = compiler.failCompile();
        BindingBeanTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        BindingBeanTestCase.assertEquals((Object)BindingMetaModelPlugin.BEAN_INVALID_TYPE, (Object)error.getCode());
        File f = (File)compiler.getSourcePath().getPath(new String[]{"plugin", "binding", "notclass", "package-info.java"});
        BindingBeanTestCase.assertEquals((Object)f, (Object)error.getSourceFile());
    }

    @Test
    public void testScope() throws Exception {
        MockApplication<?> app = this.application("plugin.binding.scope").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        String url = render.assertStringResult();
        BindingBeanTestCase.assertNotSame((Object)"", (Object)url);
        render = (MockRenderBridge)client.invoke(url);
        String result = render.assertStringResult();
        BindingBeanTestCase.assertEquals((String)"pass", (String)result);
    }
}

