/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller;

import java.util.Collections;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.test.AbstractInjectTestCase;
import juzu.test.protocol.mock.MockActionBridge;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockRenderBridge;
import org.junit.Test;

public class ActionTestCase
extends AbstractInjectTestCase {
    public ActionTestCase(InjectorProvider di) {
        super(di);
    }

    @Test
    public void testNoOp() throws Exception {
        MockApplication<?> app = this.application("plugin.controller.action.noop").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        MockActionBridge action = (MockActionBridge)client.invoke(render.assertStringResult());
        action.assertNoResponse();
    }

    @Test
    public void testRedirect() throws Exception {
        MockApplication<?> app = this.application("plugin.controller.action.redirect").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        MockActionBridge action = (MockActionBridge)client.invoke(render.assertStringResult());
        action.assertRedirect("http://www.julienviet.com");
    }

    @Test
    public void testRender() throws Exception {
        MockApplication<?> app = this.application("plugin.controller.action.render").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        MockActionBridge action = (MockActionBridge)client.invoke(render.assertStringResult());
        action.assertRender("render", Collections.singletonMap("arg", "arg_value"));
    }
}

