/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import juzu.AmbiguousResolutionException;
import juzu.impl.common.Tools;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.plugin.controller.ControllerResolver;
import juzu.impl.request.Method;
import juzu.request.Phase;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import org.junit.Test;

public class ResolverTestCase
extends AbstractTestCase {
    @Test
    public void testResolveIndex() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.controller.resolver.default_method");
        compiler.assertCompile();
        Class<?> appClass = compiler.assertClass("plugin.controller.resolver.default_method.Application");
        ApplicationDescriptor desc = ApplicationDescriptor.create(appClass);
        ControllerResolver resolver = desc.getControllers().getResolver();
        Method method = (Method)resolver.resolve((Phase)Phase.VIEW, Collections.emptySet());
        ResolverTestCase.assertEquals((String)"index", (String)method.getName());
    }

    @Test
    public void testResolveAmbiguousIndex() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.controller.resolver.ambiguous_method");
        compiler.assertCompile();
        Class<?> appClass = compiler.assertClass("plugin.controller.resolver.ambiguous_method.Application");
        ApplicationDescriptor desc = ApplicationDescriptor.create(appClass);
        ControllerResolver resolver = desc.getControllers().getResolver();
        try {
            resolver.resolve((Phase)Phase.VIEW, Collections.emptySet());
            ResolverTestCase.fail();
        }
        catch (AmbiguousResolutionException e) {
            // empty catch block
        }
    }

    @Test
    public void testDefaultControllerResolveIndex() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.controller.resolver.default_controller");
        compiler.assertCompile();
        Class<?> appClass = compiler.assertClass("plugin.controller.resolver.default_controller.Application");
        Class<?> aClass = compiler.assertClass("plugin.controller.resolver.default_controller.A");
        ApplicationDescriptor desc = ApplicationDescriptor.create(appClass);
        ControllerResolver resolver = desc.getControllers().getResolver();
        Method method = (Method)resolver.resolve((Phase)Phase.VIEW, Collections.emptySet());
        ResolverTestCase.assertEquals((String)"index", (String)method.getName());
        ResolverTestCase.assertSame(aClass, method.getMethod().getDeclaringClass());
    }

    @Test
    public void testOverload() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.controller.resolver.overload");
        compiler.assertCompile();
        Class<?> appClass = compiler.assertClass("plugin.controller.resolver.overload.Application");
        Class<?> aClass = compiler.assertClass("plugin.controller.resolver.overload.A");
        ApplicationDescriptor desc = ApplicationDescriptor.create(appClass);
        ControllerResolver resolver = desc.getControllers().getResolver();
        Method method = (Method)resolver.resolveMethod((Phase)Phase.VIEW, "A.m", (Set)Tools.set());
        ResolverTestCase.assertEquals((String)"m", (String)method.getName());
        ResolverTestCase.assertEquals((Object)Tools.set(), (Object)method.getParameterNames());
        method = (Method)resolver.resolveMethod((Phase)Phase.VIEW, "A.m", (Set)Tools.set((Object)"foo"));
        ResolverTestCase.assertEquals((String)"m", (String)method.getName());
        ResolverTestCase.assertEquals((Object)Tools.set((Object)"foo"), (Object)method.getParameterNames());
        method = (Method)resolver.resolveMethod((Phase)Phase.VIEW, "A.m", (Set)Tools.set((Object[])new String[]{"foo", "bar"}));
        ResolverTestCase.assertEquals((String)"m", (String)method.getName());
        ResolverTestCase.assertEquals((Object)Tools.set((Object[])new String[]{"foo", "bar"}), (Object)method.getParameterNames());
        method = (Method)resolver.resolveMethod((Phase)Phase.VIEW, "A.m", (Set)Tools.set((Object)"bar"));
        ResolverTestCase.assertEquals((String)"m", (String)method.getName());
        ResolverTestCase.assertEquals((Object)Tools.set((Object[])new String[]{"foo", "bar"}), (Object)method.getParameterNames());
        method = (Method)resolver.resolveMethod((Phase)Phase.VIEW, "A.m", (Set)Tools.set((Object)"bar"));
        ResolverTestCase.assertEquals((String)"m", (String)method.getName());
        ResolverTestCase.assertEquals((Object)Tools.set((Object[])new String[]{"foo", "bar"}), (Object)method.getParameterNames());
        method = (Method)resolver.resolveMethod((Phase)Phase.VIEW, "A.m", (Set)Tools.set((Object)"daa"));
        ResolverTestCase.assertEquals((String)"m", (String)method.getName());
        ResolverTestCase.assertEquals((Object)Tools.set(), (Object)method.getParameterNames());
    }

    @Test
    public void testResolution() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.controller.resolver.method");
        compiler.assertCompile();
        Class<?> aClass = compiler.assertClass("plugin.controller.resolver.method.A");
        Class<?> clazz = compiler.assertClass("plugin.controller.resolver.method.Application");
        ApplicationDescriptor desc = ApplicationDescriptor.create(clazz);
        ControllerResolver resolver = desc.getControllers().getResolver();
        Method cm1_ = desc.getControllers().getMethod(aClass, "noArg", new Class[0]);
        Method cm2_ = desc.getControllers().getMethod(aClass, "fooArg", new Class[]{String.class});
        Method cm1 = (Method)resolver.resolveMethod((Phase)Phase.VIEW, cm1_.getId(), cm1_.getParameterNames());
        ResolverTestCase.assertNotNull((Object)cm1);
        ResolverTestCase.assertEquals((String)"noArg", (String)cm1.getName());
        Method cm2 = (Method)resolver.resolveMethod((Phase)Phase.VIEW, cm2_.getId(), cm2_.getParameterNames());
        ResolverTestCase.assertNotNull((Object)cm2);
        ResolverTestCase.assertEquals((String)"fooArg", (String)cm2.getName());
    }

    @Test
    public void testTemplate() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.controller.resolver.default_controller");
        compiler.assertCompile();
        Class<?> appClass = compiler.assertClass("plugin.controller.resolver.default_controller.Application");
        Class<?> aClass = compiler.assertClass("plugin.controller.resolver.default_controller.A");
        Class<?> bClass = compiler.assertClass("plugin.controller.resolver.default_controller.B");
        ApplicationDescriptor desc = ApplicationDescriptor.create(appClass);
        ControllerResolver resolver = desc.getControllers().getResolver();
        Method method = (Method)resolver.resolve((String)null, "index", Collections.emptySet());
        ResolverTestCase.assertEquals((String)"index", (String)method.getName());
        ResolverTestCase.assertSame((Object)method.getType(), aClass);
        method = (Method)resolver.resolve("A", "index", Collections.emptySet());
        ResolverTestCase.assertEquals((String)"index", (String)method.getName());
        ResolverTestCase.assertSame((Object)method.getType(), aClass);
        method = (Method)resolver.resolve("B", "index", Collections.emptySet());
        ResolverTestCase.assertEquals((String)"index", (String)method.getName());
        ResolverTestCase.assertSame((Object)method.getType(), bClass);
    }

    @Test
    public void testTemplateResolveMethod() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.controller.resolver.method");
        compiler.assertCompile();
        Class<?> appClass = compiler.assertClass("plugin.controller.resolver.method.Application");
        Class<?> aClass = compiler.assertClass("plugin.controller.resolver.method.A");
        ApplicationDescriptor desc = ApplicationDescriptor.create(appClass);
        ControllerResolver resolver = desc.getControllers().getResolver();
        Method method = (Method)resolver.resolve((String)null, "noArg", Collections.emptySet());
        ResolverTestCase.assertEquals((String)"noArg", (String)method.getName());
        ResolverTestCase.assertSame((Object)method.getType(), aClass);
        method = (Method)resolver.resolve((String)null, "fooArg", Collections.emptySet());
        ResolverTestCase.assertEquals((String)"fooArg", (String)method.getName());
        ResolverTestCase.assertSame((Object)method.getType(), aClass);
        method = (Method)resolver.resolve((String)null, "fooArg", Collections.singleton("foo"));
        ResolverTestCase.assertEquals((String)"fooArg", (String)method.getName());
        ResolverTestCase.assertSame((Object)method.getType(), aClass);
        method = (Method)resolver.resolve((String)null, "fooArg", Collections.singleton("bar"));
        ResolverTestCase.assertNull((Object)method);
    }
}

