/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller;

import juzu.PropertyType;
import juzu.impl.common.JSON;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.test.AbstractInjectTestCase;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockRenderBridge;
import org.junit.Test;

public class URLTestCase
extends AbstractInjectTestCase {
    public URLTestCase(InjectorProvider di) {
        super(di);
    }

    @Test
    public void testSimple() throws Exception {
        MockApplication<?> app = this.application("plugin.controller.url.simple");
        app.init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        JSON url = (JSON)JSON.parse((String)render.assertStringResult());
        URLTestCase.assertFalse((boolean)url.getJSON("properties").contains(PropertyType.ESCAPE_XML.getClass().getName()));
    }

    @Test
    public void testEscapeXML() throws Exception {
        MockApplication<?> app = this.application("plugin.controller.url.escapexml");
        app.init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        JSON url = (JSON)JSON.parse((String)render.assertStringResult());
        URLTestCase.assertEquals((Object)Boolean.TRUE, (Object)url.getJSON("properties").get(PropertyType.ESCAPE_XML.getClass().getName()));
    }

    @Test
    public void testInvalidProperty() throws Exception {
        MockApplication<?> app = this.application("plugin.controller.url.invalidproperty");
        app.init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        URLTestCase.assertEquals((String)"pass", (String)render.assertStringResult());
    }
}

