/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template;

import java.io.File;
import java.util.List;
import juzu.impl.compiler.CompilationError;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import org.junit.Test;

public class URLTestCase
extends AbstractTestCase {
    @Test
    public void testResolution() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.template.url.resolution");
        compiler.assertCompile();
    }

    public void testInvalidMethodName() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.template.url.invalid_method_name");
        List<CompilationError> errors = compiler.failCompile();
        URLTestCase.assertEquals((String)("Was expecting 1 error instead of " + errors), (int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        URLTestCase.assertEquals((String)"/plugin/template/url/invalid_method_name/A.java", (String)error.getSource());
    }

    public void testInvalidMethodArgs() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.template.url.invalid_method_args");
        List<CompilationError> errors = compiler.failCompile();
        URLTestCase.assertEquals((String)("Was expecting 1 error instead of " + errors), (int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        URLTestCase.assertEquals((String)"/plugin/template/url/invalid_method_args/A.java", (String)error.getSource());
    }

    public void testOverload() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.template.url.overload");
        compiler.assertCompile();
    }
}

