/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.util.Collections;
import juzu.impl.router.PathParam;
import juzu.impl.router.PatternRoute;
import juzu.impl.router.Route;
import juzu.impl.router.RouteMatch;
import juzu.impl.router.Router;
import juzu.impl.router.SegmentRoute;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class BuildRouteTestCase
extends AbstractTestCase {
    @Test
    public void testParameterSegment() throws Exception {
        Router router = new Router();
        router.append("/{a}");
        BuildRouteTestCase.assertEquals((int)0, (int)router.getSegmentNames().size());
        BuildRouteTestCase.assertEquals((int)1, (int)router.getPatternSize());
        PatternRoute patternRoute = router.getPattern(0);
        BuildRouteTestCase.assertEquals((String)"(?:([^/]+))(?:(?<=^)|(?=/)|$)", (String)patternRoute.pattern.re.getPattern());
        BuildRouteTestCase.assertEquals((int)1, (int)patternRoute.params.length);
        BuildRouteTestCase.assertEquals((String)"a", (String)patternRoute.params[0].name);
        BuildRouteTestCase.assertEquals((String)"^(.+)$", (String)patternRoute.params[0].matchingRegex[0].re.getPattern());
        BuildRouteTestCase.assertFalse((boolean)patternRoute.params[0].preservePath);
        BuildRouteTestCase.assertEquals((int)2, (int)patternRoute.chunks.length);
        BuildRouteTestCase.assertEquals((String)"", (String)patternRoute.chunks[0]);
        BuildRouteTestCase.assertEquals((String)"", (String)patternRoute.chunks[1]);
    }

    @Test
    public void testQualifiedParameterSegment() throws Exception {
        Router router = new Router();
        router.append("/{q:a}");
        BuildRouteTestCase.assertEquals((int)0, (int)router.getSegmentNames().size());
        BuildRouteTestCase.assertEquals((int)1, (int)router.getPatternSize());
        PatternRoute patternRoute = router.getPattern(0);
        BuildRouteTestCase.assertEquals((String)"(?:([^/]+))(?:(?<=^)|(?=/)|$)", (String)patternRoute.pattern.re.getPattern());
        BuildRouteTestCase.assertEquals((int)1, (int)patternRoute.params.length);
        BuildRouteTestCase.assertEquals((String)"q:a", (String)patternRoute.params[0].name);
        BuildRouteTestCase.assertEquals((String)"^(.+)$", (String)patternRoute.params[0].matchingRegex[0].re.getPattern());
        BuildRouteTestCase.assertFalse((boolean)patternRoute.params[0].preservePath);
        BuildRouteTestCase.assertEquals((int)2, (int)patternRoute.chunks.length);
        BuildRouteTestCase.assertEquals((String)"", (String)patternRoute.chunks[0]);
        BuildRouteTestCase.assertEquals((String)"", (String)patternRoute.chunks[1]);
    }

    @Test
    public void testPatternSegment() throws Exception {
        Router router = new Router();
        router.append("/{a}", Collections.singletonMap("a", PathParam.matching((String)".*")));
        BuildRouteTestCase.assertEquals((int)0, (int)router.getSegmentNames().size());
        BuildRouteTestCase.assertEquals((int)1, (int)router.getPatternSize());
        PatternRoute patternRoute = router.getPattern(0);
        BuildRouteTestCase.assertEquals((String)"(?:([^/]*))(?:(?<=^)|(?=/)|$)", (String)patternRoute.pattern.re.getPattern());
        BuildRouteTestCase.assertEquals((int)1, (int)patternRoute.params.length);
        BuildRouteTestCase.assertEquals((String)"a", (String)patternRoute.params[0].name);
        BuildRouteTestCase.assertEquals((String)"^(.*)$", (String)patternRoute.params[0].matchingRegex[0].re.getPattern());
        BuildRouteTestCase.assertFalse((boolean)patternRoute.params[0].preservePath);
        BuildRouteTestCase.assertEquals((int)2, (int)patternRoute.chunks.length);
        BuildRouteTestCase.assertEquals((String)"", (String)patternRoute.chunks[0]);
        BuildRouteTestCase.assertEquals((String)"", (String)patternRoute.chunks[1]);
    }

    @Test
    public void testSamePrefix() throws Exception {
        Router router = new Router();
        router.append("/public/foo");
        router.append("/public/bar");
        BuildRouteTestCase.assertEquals((int)2, (int)router.getSegmentSize("public"));
        SegmentRoute publicRoute1 = router.getSegment("public", 0);
        BuildRouteTestCase.assertEquals((int)1, (int)publicRoute1.getSegmentSize("foo"));
        SegmentRoute publicRoute2 = router.getSegment("public", 1);
        BuildRouteTestCase.assertEquals((int)1, (int)publicRoute2.getSegmentSize("bar"));
    }

    @Test
    public void testClear() throws Exception {
        Router router = new Router();
        Route foo = router.append("/foo");
        RouteMatch match = router.route("/foo");
        BuildRouteTestCase.assertNotNull((Object)match);
        BuildRouteTestCase.assertSame((Object)foo, (Object)match.getRoute());
        Route bar = foo.append("/bar");
        match = router.route("/foo/bar");
        BuildRouteTestCase.assertNotNull((Object)match);
        BuildRouteTestCase.assertSame((Object)bar, (Object)match.getRoute());
        foo.clearChildren();
        match = router.route("/foo/bar");
        BuildRouteTestCase.assertNull((Object)match);
        match = router.route("/foo");
        BuildRouteTestCase.assertNotNull((Object)match);
        BuildRouteTestCase.assertSame((Object)foo, (Object)match.getRoute());
    }

    private void assertEquals(Route expectedRoute, Route route) {
        int i;
        BuildRouteTestCase.assertEquals(expectedRoute.getClass(), route.getClass());
        BuildRouteTestCase.assertEquals((Object)expectedRoute.getSegmentNames(), (Object)route.getSegmentNames());
        for (String segmentName : expectedRoute.getSegmentNames()) {
            BuildRouteTestCase.assertEquals((int)expectedRoute.getSegmentSize(segmentName), (int)route.getSegmentSize(segmentName));
            for (int segmentIndex = 0; segmentIndex < expectedRoute.getSegmentSize(segmentName); ++segmentIndex) {
                SegmentRoute expectedSegmentRoute = expectedRoute.getSegment(segmentName, segmentIndex);
                SegmentRoute segmentRoute = route.getSegment(segmentName, segmentIndex);
                this.assertEquals((Route)expectedSegmentRoute, (Route)segmentRoute);
            }
        }
        BuildRouteTestCase.assertEquals((int)expectedRoute.getPatternSize(), (int)route.getPatternSize());
        for (i = 0; i < expectedRoute.getPatternSize(); ++i) {
            this.assertEquals((Route)expectedRoute.getPattern(i), (Route)route.getPattern(i));
        }
        if (route instanceof PatternRoute) {
            BuildRouteTestCase.assertEquals((String)((PatternRoute)expectedRoute).pattern.toString(), (String)((PatternRoute)route).pattern.toString());
            BuildRouteTestCase.assertEquals((int)((PatternRoute)expectedRoute).params.length, (int)((PatternRoute)route).params.length);
            for (i = 0; i < ((PatternRoute)expectedRoute).params.length; ++i) {
                PathParam expectedParam = ((PatternRoute)expectedRoute).params[i];
                PathParam param = ((PatternRoute)route).params[i];
                BuildRouteTestCase.assertEquals((String)expectedParam.name, (String)param.name);
                BuildRouteTestCase.assertEquals((int)expectedParam.matchingRegex.length, (int)param.matchingRegex.length);
                for (int j = 0; j < expectedParam.matchingRegex.length; ++j) {
                    BuildRouteTestCase.assertEquals((String)expectedParam.matchingRegex[j].toString(), (String)param.matchingRegex[j].toString());
                }
                BuildRouteTestCase.assertEquals((boolean)expectedParam.preservePath, (boolean)param.preservePath);
            }
        } else if (route instanceof SegmentRoute) {
            BuildRouteTestCase.assertEquals((String)((SegmentRoute)expectedRoute).name, (String)((SegmentRoute)route).name);
        }
    }
}

