/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.util.List;
import juzu.impl.router.ValueResolverFactory;
import juzu.impl.router.regex.RENode;
import juzu.impl.router.regex.REParser;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class FooRendererTestCase
extends AbstractTestCase {
    private static void assertSatisfied(String expression, String ... expected) throws Exception {
        RENode root = new REParser((CharSequence)expression).parse();
        List alternatives = new ValueResolverFactory().foo(root);
        FooRendererTestCase.assertEquals((int)expected.length, (int)alternatives.size());
        for (int i = 0; i < expected.length; ++i) {
            FooRendererTestCase.assertEquals((String)expected[i], (String)((ValueResolverFactory.Alternative)alternatives.get(i)).getResolvingExpression().toString());
        }
    }

    @Test
    public void testDisjunction() throws Exception {
        FooRendererTestCase.assertSatisfied("a|b", "a", "b");
    }

    @Test
    public void testAlternative() throws Exception {
        FooRendererTestCase.assertSatisfied("ab", "ab");
    }

    @Test
    public void testCharacterClassRange() throws Exception {
        FooRendererTestCase.assertSatisfied("[b-c]", "b");
    }

    @Test
    public void testCharacterClassOr() throws Exception {
        FooRendererTestCase.assertSatisfied("[bc]", "b");
    }

    @Test
    public void testCharacterClassAnd() throws Exception {
        FooRendererTestCase.assertSatisfied("[b&&b]", "b");
    }

    @Test
    public void testQuantifier() throws Exception {
        FooRendererTestCase.assertSatisfied("b{2,3}", "bb");
    }

    @Test
    public void testCharacterClassNegateChar() throws Exception {
        FooRendererTestCase.assertSatisfied("[^a]", " ");
    }

    @Test
    public void testCharacterClassNegateOr() throws Exception {
        FooRendererTestCase.assertSatisfied("[^ !]", "\"");
    }

    @Test
    public void testCharacterClassNegateAnd() throws Exception {
        FooRendererTestCase.assertSatisfied("[^a&&b]", " ");
    }

    @Test
    public void testAny() throws Exception {
        FooRendererTestCase.assertSatisfied(".", "a");
    }

    @Test
    public void testNonCapturingGroup() throws Exception {
        FooRendererTestCase.assertSatisfied("(?:a|b)", "a");
    }

    @Test
    public void testGroup() throws Exception {
        FooRendererTestCase.assertSatisfied("(a|b)", "(a|b)");
    }

    @Test
    public void testComplex() throws Exception {
        FooRendererTestCase.assertSatisfied("[a-z&&f-t&&p-q]", "p");
    }
}

