/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import juzu.impl.router.Path;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class PathTestCase
extends AbstractTestCase {
    @Test
    public void testFoo() throws Exception {
        PathTestCase.assertEquals((String)"", (String)Path.parse((String)"").getValue());
        PathTestCase.assertEquals((String)"a", (String)Path.parse((String)"a").getValue());
        PathTestCase.assertEquals((String)"?", (String)Path.parse((String)"%3F").getValue());
        PathTestCase.assertEquals((String)" ", (String)Path.parse((String)"%20").getValue());
        PathTestCase.assertEquals((String)"? ", (String)Path.parse((String)"%3F%20").getValue());
        Path p2 = Path.parse((String)"_");
        PathTestCase.assertEquals((String)"_", (String)p2.getValue());
        PathTestCase.assertEquals((int)0, (int)p2.getRawStart(0));
        PathTestCase.assertEquals((int)1, (int)p2.getRawEnd(0));
        PathTestCase.assertEquals((int)1, (int)p2.getRawLength(0));
        Path p3 = Path.parse((String)"a%5Fb%5Fc");
        PathTestCase.assertEquals((String)"a_b_c", (String)p3.getValue());
        PathTestCase.assertEquals((int)0, (int)p3.getRawStart(0));
        PathTestCase.assertEquals((int)1, (int)p3.getRawEnd(0));
        PathTestCase.assertEquals((int)1, (int)p3.getRawLength(0));
        PathTestCase.assertEquals((int)1, (int)p3.getRawStart(1));
        PathTestCase.assertEquals((int)4, (int)p3.getRawEnd(1));
        PathTestCase.assertEquals((int)3, (int)p3.getRawLength(1));
        PathTestCase.assertEquals((int)4, (int)p3.getRawStart(2));
        PathTestCase.assertEquals((int)5, (int)p3.getRawEnd(2));
        PathTestCase.assertEquals((int)1, (int)p3.getRawLength(2));
        PathTestCase.assertEquals((int)5, (int)p3.getRawStart(3));
        PathTestCase.assertEquals((int)8, (int)p3.getRawEnd(3));
        PathTestCase.assertEquals((int)3, (int)p3.getRawLength(3));
        PathTestCase.assertEquals((int)8, (int)p3.getRawStart(4));
        PathTestCase.assertEquals((int)9, (int)p3.getRawEnd(4));
        PathTestCase.assertEquals((int)1, (int)p3.getRawLength(4));
        Path p4 = p3.subPath(2);
        PathTestCase.assertEquals((int)0, (int)p4.getRawStart(0));
        PathTestCase.assertEquals((int)1, (int)p4.getRawEnd(0));
        PathTestCase.assertEquals((int)1, (int)p4.getRawLength(0));
        PathTestCase.assertEquals((int)1, (int)p4.getRawStart(1));
        PathTestCase.assertEquals((int)4, (int)p4.getRawEnd(1));
        PathTestCase.assertEquals((int)3, (int)p4.getRawLength(1));
        PathTestCase.assertEquals((int)4, (int)p4.getRawStart(2));
        PathTestCase.assertEquals((int)5, (int)p4.getRawEnd(2));
        PathTestCase.assertEquals((int)1, (int)p4.getRawLength(2));
    }

    @Test
    public void testOtherChar() {
        this.assertInvalid("\u00e9");
    }

    @Test
    public void testPercent1() {
        Path path = Path.parse((String)"%5F");
        PathTestCase.assertEquals((String)"_", (String)path.getValue());
        PathTestCase.assertEquals((int)0, (int)path.getRawStart(0));
        PathTestCase.assertEquals((int)3, (int)path.getRawEnd(0));
        PathTestCase.assertEquals((int)3, (int)path.getRawLength(0));
    }

    @Test
    public void testPercent2() {
        Path path = Path.parse((String)"%C2%A2");
        PathTestCase.assertEquals((int)1, (int)path.length());
        PathTestCase.assertEquals((char)'\u00a2', (char)path.charAt(0));
        PathTestCase.assertEquals((int)0, (int)path.getRawStart(0));
        PathTestCase.assertEquals((int)6, (int)path.getRawEnd(0));
        PathTestCase.assertEquals((int)6, (int)path.getRawLength(0));
    }

    @Test
    public void testPercent3() {
        Path path = Path.parse((String)"%E2%82%AC");
        PathTestCase.assertEquals((int)1, (int)path.length());
        PathTestCase.assertEquals((char)'\u20ac', (char)path.charAt(0));
        PathTestCase.assertEquals((int)0, (int)path.getRawStart(0));
        PathTestCase.assertEquals((int)9, (int)path.getRawEnd(0));
        PathTestCase.assertEquals((int)9, (int)path.getRawLength(0));
    }

    @Test
    public void testSubPath() {
        Path path = Path.parse((String)"foo");
        PathTestCase.assertEquals((String)"foo", (String)path.subPath(0).getValue());
        PathTestCase.assertEquals((String)"oo", (String)path.subPath(1).getValue());
        PathTestCase.assertEquals((String)"o", (String)path.subPath(2).getValue());
        PathTestCase.assertEquals((String)"", (String)path.subPath(3).getValue());
        try {
            path.subPath(4);
            PathTestCase.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        try {
            path.subPath(-1);
            PathTestCase.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalid() {
        this.assertInvalid("%");
        this.assertInvalid("%1z");
        this.assertInvalid("%C2_A2");
        this.assertInvalid("%C2%A");
        this.assertInvalid("%FF");
    }

    private void assertInvalid(String s) {
        try {
            Path.parse((String)s);
            PathTestCase.fail((String)("Was expecting " + s + " to be invalid"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

