/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import juzu.impl.router.AbstractControllerTestCase;
import juzu.impl.router.PathParam;
import juzu.impl.router.Route;
import juzu.impl.router.RouterAssert;
import org.junit.Test;

public class PortalConfigurationTestCase
extends AbstractControllerTestCase {
    private RouterAssert router;
    private Route portal;
    private Route group;
    private Route user;

    public void setUp() throws Exception {
        this.router = new RouterAssert();
        Map<String, PathParam.Builder> params = Collections.singletonMap("gtn:path", PathParam.matching((String)".*").preservePath(true));
        this.portal = this.router.append("/private/{gtn:sitetype}/{gtn:sitename}{gtn:path}", params);
        this.group = this.router.append("/groups/{gtn:sitetype}/{gtn:sitename}{gtn:path}", params);
        this.user = this.router.append("/users/{gtn:sitetype}/{gtn:sitename}{gtn:path}", params);
    }

    @Test
    public void testComponent() throws Exception {
        HashMap<String, String> expectedParameters = new HashMap<String, String>();
        expectedParameters.put("gtn:sitename", "classic");
        expectedParameters.put("gtn:sitetype", "portal");
        expectedParameters.put("gtn:path", "/");
        this.router.assertRoute(this.portal, expectedParameters, "/private/portal/classic/");
        PortalConfigurationTestCase.assertEquals((String)"/private/portal/classic/", (String)this.portal.matches(expectedParameters).render());
    }

    @Test
    public void testPrivateClassic() throws Exception {
        HashMap<String, String> expectedParameters = new HashMap<String, String>();
        expectedParameters.put("gtn:sitename", "classic");
        expectedParameters.put("gtn:sitetype", "portal");
        expectedParameters.put("gtn:path", "");
        this.router.assertRoute(this.portal, expectedParameters, "/private/portal/classic");
        PortalConfigurationTestCase.assertEquals((String)"/private/portal/classic", (String)this.portal.matches(expectedParameters).render());
    }

    @Test
    public void testPrivateClassicSlash() throws Exception {
        HashMap<String, String> expectedParameters = new HashMap<String, String>();
        expectedParameters.put("gtn:sitename", "classic");
        expectedParameters.put("gtn:sitetype", "portal");
        expectedParameters.put("gtn:path", "/");
        this.router.assertRoute(this.portal, expectedParameters, "/private/portal/classic/");
        PortalConfigurationTestCase.assertEquals((String)"/private/portal/classic/", (String)this.portal.matches(expectedParameters).render());
    }

    @Test
    public void testPrivateClassicHome() throws Exception {
        HashMap<String, String> expectedParameters = new HashMap<String, String>();
        expectedParameters.put("gtn:sitename", "classic");
        expectedParameters.put("gtn:sitetype", "portal");
        expectedParameters.put("gtn:path", "/home");
        this.router.assertRoute(this.portal, expectedParameters, "/private/portal/classic/home");
        PortalConfigurationTestCase.assertEquals((String)"/private/portal/classic/home", (String)this.portal.matches(expectedParameters).render());
    }

    @Test
    public void testSiteType() throws Exception {
        HashMap<String, String> expectedParameters = new HashMap<String, String>();
        expectedParameters.put("gtn:sitetype", "group");
        expectedParameters.put("gtn:sitename", "platform");
        expectedParameters.put("gtn:path", "/administration/registry");
        this.router.assertRoute(this.portal, expectedParameters, "/private/group/platform/administration/registry");
        PortalConfigurationTestCase.assertEquals((String)"/private/group/platform/administration/registry", (String)this.portal.matches(expectedParameters).render());
        HashMap<String, String> expectedParameters1 = new HashMap<String, String>();
        expectedParameters1.put("gtn:sitetype", "user");
        expectedParameters1.put("gtn:sitename", "root");
        expectedParameters1.put("gtn:path", "/tab_0");
        this.router.assertRoute(this.portal, expectedParameters1, "/private/user/root/tab_0");
        PortalConfigurationTestCase.assertEquals((String)"/private/user/root/tab_0", (String)this.portal.matches(expectedParameters1).render());
    }
}

