/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.util.Collections;
import juzu.impl.router.AbstractControllerTestCase;
import juzu.impl.router.PathParam;
import juzu.impl.router.Route;
import juzu.impl.router.Router;
import org.junit.Test;

public class RenderTestCase
extends AbstractControllerTestCase {
    @Test
    public void testRoot1() throws Exception {
        Router router = new Router();
        Route r = router.append("/");
        RenderTestCase.assertEquals((String)"/", (String)r.matches(Collections.emptyMap()).render());
    }

    @Test
    public void testRoot2() throws Exception {
        Router router = new Router();
        Route r = router.append("");
        RenderTestCase.assertEquals((String)"/", (String)r.matches(Collections.emptyMap()).render());
    }

    @Test
    public void testA() throws Exception {
        Router router = new Router();
        Route r = router.append("/a");
        RenderTestCase.assertEquals((String)"/a", (String)r.matches(Collections.emptyMap()).render());
    }

    @Test
    public void testAB() throws Exception {
        Router router = new Router();
        Route r = router.append("/a/b");
        RenderTestCase.assertEquals((String)"/a/b", (String)r.matches(Collections.emptyMap()).render());
    }

    @Test
    public void testPathParam() throws Exception {
        Router router = new Router();
        Route r = router.append("/{p}");
        RenderTestCase.assertEquals((String)"/a", (String)r.matches(Collections.singletonMap("p", "a")).render());
        RenderTestCase.assertNull((Object)r.matches(Collections.emptyMap()));
    }

    @Test
    public void testSimplePatternPathParam() throws Exception {
        Router router = new Router();
        Route r = router.append("/{p}", Collections.singletonMap("p", PathParam.matching((String)"a")));
        RenderTestCase.assertEquals((String)"/a", (String)r.matches(Collections.singletonMap("p", "a")).render());
        RenderTestCase.assertNull((Object)r.matches(Collections.singletonMap("p", "ab")));
    }

    @Test
    public void testPrecedence() throws Exception {
        Router router = new Router();
        Route a = router.append("/a");
        Route b = router.append("/{p}/b", Collections.singletonMap("p", PathParam.matching((String)"a")));
        RenderTestCase.assertEquals((String)"/a", (String)a.matches(Collections.emptyMap()).render());
        RenderTestCase.assertEquals((String)"/a/b", (String)b.matches(Collections.singletonMap("p", "a")).render());
    }

    @Test
    public void testLang() throws Exception {
        Router router = new Router();
        Route r = router.append("/{a}b", Collections.singletonMap("a", PathParam.matching((String)"(([A-Za-z]{2})/)?").preservePath(true)));
        RenderTestCase.assertEquals((String)"/fr/b", (String)r.matches(Collections.singletonMap("a", "fr/")).render());
        RenderTestCase.assertEquals((String)"/b", (String)r.matches(Collections.singletonMap("a", "")).render());
    }

    @Test
    public void testDisjunction() throws Exception {
        Router router = new Router();
        Route r = router.append("/{a}", Collections.singletonMap("a", PathParam.matching((String)"a|b")));
        RenderTestCase.assertEquals((String)"/b", (String)r.matches(Collections.singletonMap("a", "b")).render());
    }

    @Test
    public void testCaptureGroup() throws Exception {
        Router router = new Router();
        Route r = router.append("/{a}", Collections.singletonMap("a", PathParam.matching((String)"a(.)c").captureGroup(true)));
        RenderTestCase.assertEquals((String)"/abc", (String)r.matches(Collections.singletonMap("a", "b")).render());
    }
}

