/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import juzu.impl.router.RouteEscaper;
import juzu.impl.router.regex.RENode;
import juzu.impl.router.regex.REParser;
import juzu.impl.router.regex.RERenderer;
import juzu.impl.router.regex.REVisitor;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class RouteEscaperTestCase
extends AbstractTestCase {
    private void match(String pattern, String test, String expectedValue) throws Exception {
        REParser parser = new REParser((CharSequence)pattern);
        RouteEscaper escaper = new RouteEscaper('/', '_');
        RENode.Disjunction re = parser.parseDisjunction();
        re.accept((REVisitor)escaper);
        Pattern p = Pattern.compile(((StringBuilder)RERenderer.render((RENode)re, (Appendable)new StringBuilder())).toString());
        Matcher matcher = p.matcher(test);
        RouteEscaperTestCase.assertTrue((boolean)matcher.find());
        RouteEscaperTestCase.assertEquals((String)expectedValue, (String)matcher.group());
    }

    @Test
    public void testMatch() throws Exception {
        this.match(".*", "_", "_");
        this.match(".*", "_/", "_");
        this.match(".*", "_/_", "_");
        this.match("/", "_/", "_");
        this.match("/*", "_/_", "_");
        this.match("[/a]*", "_a_/_", "_a_");
        this.match("[,-1&&[^/]]*", "_/_", "");
    }

    @Test
    public void testGroup() throws Exception {
        this.match("(/)", "_", "_");
        this.match("(?:/)", "_", "_");
        this.match(".(?=/)", "a_", "a");
        this.match("a(?!/)", "ab", "a");
        this.match(".(?<=/)a", "ba_a", "_a");
        this.match(".(?<!/)a", "_aba", "ba");
    }
}

