/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.util.Collections;
import juzu.impl.router.AbstractControllerTestCase;
import juzu.impl.router.Route;
import juzu.impl.router.RouterAssert;
import org.junit.Test;

public class RoutePriorityTestCase
extends AbstractControllerTestCase {
    @Test
    public void testExactMatchingAfterWildcard() throws Exception {
        RouterAssert router = new RouterAssert();
        Route a = router.append("/{foo}");
        Route b = router.append("/foo");
        router.assertRoute(a, "/foo");
        RoutePriorityTestCase.assertEquals((String)"/foo", (String)a.matches(Collections.singletonMap("foo", "foo")).render());
        RoutePriorityTestCase.assertEquals((String)"/b", (String)a.matches(Collections.singletonMap("foo", "b")).render());
        RoutePriorityTestCase.assertEquals((String)"/foo", (String)b.matches(Collections.singletonMap("foo", "foo")).render());
        RoutePriorityTestCase.assertEquals((String)"/foo", (String)b.matches(Collections.singletonMap("foo", "b")).render());
    }

    @Test
    public void testExactMatchingBeforeWildcard() throws Exception {
        RouterAssert router = new RouterAssert();
        Route a = router.append("/foo");
        Route b = router.append("/{foo}");
        router.assertRoute(a, "/foo");
        RoutePriorityTestCase.assertEquals((String)"/foo", (String)a.matches(Collections.singletonMap("foo", "b")).render());
        RoutePriorityTestCase.assertEquals((String)"/foo", (String)a.matches(Collections.singletonMap("foo", "foo")).render());
        RoutePriorityTestCase.assertEquals((String)"/b", (String)b.matches(Collections.singletonMap("foo", "b")).render());
        RoutePriorityTestCase.assertEquals((String)"/foo", (String)b.matches(Collections.singletonMap("foo", "foo")).render());
    }
}

