/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import juzu.impl.router.parser.RouteParser;
import juzu.impl.router.parser.RouteParserHandler;
import juzu.impl.router.regex.SyntaxException;
import juzu.test.AbstractTestCase;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteParserTestCase
extends AbstractTestCase {
    private List<String> parse(String route) {
        try {
            Collector collector = new Collector();
            RouteParser.parse((CharSequence)route, (RouteParserHandler)collector);
            return collector.chunks;
        }
        catch (SyntaxException e) {
            throw RouteParserTestCase.failure(e);
        }
    }

    private void fail(String route, int expectedCode, int index) {
        try {
            RouteParser.parse((CharSequence)route, (RouteParserHandler)new Collector());
            throw RouteParserTestCase.failure("Was expecting route to fail at " + index);
        }
        catch (SyntaxException e) {
            RouteParserTestCase.assertEquals((int)expectedCode, (int)e.getCode());
            RouteParserTestCase.assertNotNull((Object)e.getLocation());
            RouteParserTestCase.assertEquals((int)index, (int)e.getLocation().getCol());
            RouteParserTestCase.assertEquals((int)1, (int)e.getLocation().getLine());
            return;
        }
    }

    @Test
    public void testSimple() {
        RouteParserTestCase.assertEquals(Arrays.asList("$"), this.parse(""));
        RouteParserTestCase.assertEquals(Arrays.asList("/a", "$"), this.parse("a"));
        RouteParserTestCase.assertEquals(Arrays.asList("/a", "$"), this.parse("/a"));
        RouteParserTestCase.assertEquals(Arrays.asList("/a", "$"), this.parse("//a"));
        RouteParserTestCase.assertEquals(Arrays.asList("/a", "/b", "$"), this.parse("a/b"));
    }

    @Test
    public void testPathParam() {
        RouteParserTestCase.assertEquals(Arrays.asList("/{a}", "$"), this.parse("{a}"));
        RouteParserTestCase.assertEquals(Arrays.asList("/a{b}c", "$"), this.parse("a{b}c"));
    }

    @Test
    public void testEndWithSeparator() {
        RouteParserTestCase.assertEquals(Arrays.asList("/$"), this.parse("/"));
        RouteParserTestCase.assertEquals(Arrays.asList("/a", "/$"), this.parse("a/"));
        RouteParserTestCase.assertEquals(Arrays.asList("/a", "/$"), this.parse("a//"));
        RouteParserTestCase.assertEquals(Arrays.asList("/a", "/$"), this.parse("/a/"));
        RouteParserTestCase.assertEquals(Arrays.asList("/a", "/$"), this.parse("/a//"));
    }

    @Test
    public void testInvalid() {
        this.fail("{", 0, 2);
        this.fail("{a", 0, 3);
        this.fail("{}", 1, 2);
    }

    static class Collector
    implements RouteParserHandler {
        private final List<String> chunks = new ArrayList<String>();
        private final StringBuilder buffer = new StringBuilder();

        Collector() {
        }

        public void segmentOpen() {
            this.buffer.append("/");
        }

        public void segmentChunk(CharSequence s, int from, int to) {
            this.buffer.append(s, from, to);
        }

        public void segmentClose() {
            this.chunks.add(this.buffer.toString());
            this.buffer.setLength(0);
        }

        public void pathClose(boolean slash) {
            if (slash) {
                this.chunks.add("/$");
            } else {
                this.chunks.add("$");
            }
        }

        public void query() {
            this.chunks.add("?");
        }

        public void exprOpen() {
            this.buffer.append('{');
        }

        public void exprIdent(CharSequence s, int from, int to) {
            this.buffer.append(s, from, to);
        }

        public void exprClose() {
            this.buffer.append('}');
        }
    }
}

