/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router.regex;

import java.util.regex.Pattern;
import junit.framework.Assert;
import juzu.impl.router.regex.Quantifier;
import juzu.impl.router.regex.RENode;
import juzu.impl.router.regex.REParser;
import juzu.impl.router.regex.SyntaxException;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class ParserTestCase
extends AbstractTestCase {
    @Test
    public void testSomeStuff() {
        Pattern pattern = Pattern.compile("^[\\^a\b]$");
        ParserTestCase.assertTrue((boolean)pattern.matcher("^").matches());
        ParserTestCase.assertTrue((boolean)pattern.matcher("a").matches());
    }

    public void testDisjunction() {
        new ParserTester("a|").assertParseDisjunction("<c>a</c>|");
        new ParserTester("|a").assertParseDisjunction("|<c>a</c>");
        new ParserTester("a|b").assertParseDisjunction("<c>a</c>|<c>b</c>");
    }

    public void testExtendedRegexp() {
        new ParserTester("").assertParseDisjunction("");
        new ParserTester(".").assertParseDisjunction("<./>");
        new ParserTester("^").assertParseDisjunction("<^/>");
        new ParserTester("^$").assertParseDisjunction("<^/><$/>");
        new ParserTester("a").assertParseDisjunction("<c>a</c>");
        new ParserTester("a|b").assertParseDisjunction("<c>a</c>|<c>b</c>");
        new ParserTester("a|b|c").assertParseDisjunction("<c>a</c>|<c>b</c>|<c>c</c>");
        new ParserTester("a+|b*").assertParseDisjunction("<+><c>a</c></+>|<*><c>b</c></*>");
        new ParserTester("\\.").assertParseDisjunction("<c>.</c>");
    }

    public void testExpression() {
        new ParserTester("").assertNotParseExpression();
        new ParserTester("^").assertParseExpression("<^/>", 1);
        new ParserTester("^+").assertParseExpression("<+><^/></+>", 2);
        new ParserTester("$").assertParseExpression("<$/>", 1);
        new ParserTester("$+").assertParseExpression("<+><$/></+>", 2);
        new ParserTester("a").assertParseExpression("<c>a</c>", 1);
        new ParserTester("a+").assertParseExpression("<+><c>a</c></+>", 2);
        new ParserTester(".").assertParseExpression("<./>", 1);
        new ParserTester(".+").assertParseExpression("<+><./></+>", 2);
        new ParserTester("\\+").assertParseExpression("<c>+</c>", 2);
        new ParserTester("\\++").assertParseExpression("<+><c>+</c></+>", 3);
        new ParserTester("*").assertNotParseExpression();
        new ParserTester("+").assertNotParseExpression();
        new ParserTester("?").assertNotParseExpression();
        new ParserTester("{").assertNotParseExpression();
        new ParserTester("|").assertNotParseExpression();
    }

    public void testGroup() {
        new ParserTester("(a)").assertParseExpression("<(><c>a</c></(>", 3);
        new ParserTester("(a(b)c)").assertParseExpression("<(><c>a</c><(><c>b</c></(><c>c</c></(>", 7);
        new ParserTester("(?:a)").assertParseExpression("<(?:><c>a</c></(?:>", 5);
        new ParserTester("(?=a)").assertParseExpression("<(?=><c>a</c></(?=>", 5);
        new ParserTester("(?!a)").assertParseExpression("<(?!><c>a</c></(?!>", 5);
        new ParserTester("(?<=a)").assertParseExpression("<(?<=><c>a</c></(?<=>", 6);
        new ParserTester("(?<!a)").assertParseExpression("<(?<!><c>a</c></(?<!>", 6);
        new ParserTester("(?)").assertParseExpression("<(><c>?</c></(>", 3);
        new ParserTester("(?_)").assertNotParseExpression();
        new ParserTester("(?<_)").assertNotParseExpression();
    }

    public void testQuantifier() {
        new ParserTester("*").assertParseQuantifier(Quantifier.zeroOrMore((Quantifier.Mode)Quantifier.Mode.GREEDY));
        new ParserTester("+").assertParseQuantifier(Quantifier.oneOrMore((Quantifier.Mode)Quantifier.Mode.GREEDY));
        new ParserTester("?").assertParseQuantifier(Quantifier.onceOrNotAtAll((Quantifier.Mode)Quantifier.Mode.GREEDY));
        new ParserTester("*a").assertParseQuantifier(Quantifier.zeroOrMore((Quantifier.Mode)Quantifier.Mode.GREEDY));
        new ParserTester("+a").assertParseQuantifier(Quantifier.oneOrMore((Quantifier.Mode)Quantifier.Mode.GREEDY));
        new ParserTester("?a").assertParseQuantifier(Quantifier.onceOrNotAtAll((Quantifier.Mode)Quantifier.Mode.GREEDY));
        new ParserTester("*?").assertParseQuantifier(Quantifier.zeroOrMore((Quantifier.Mode)Quantifier.Mode.RELUCTANT));
        new ParserTester("+?").assertParseQuantifier(Quantifier.oneOrMore((Quantifier.Mode)Quantifier.Mode.RELUCTANT));
        new ParserTester("??").assertParseQuantifier(Quantifier.onceOrNotAtAll((Quantifier.Mode)Quantifier.Mode.RELUCTANT));
        new ParserTester("*+").assertParseQuantifier(Quantifier.zeroOrMore((Quantifier.Mode)Quantifier.Mode.POSSESSIVE));
        new ParserTester("++").assertParseQuantifier(Quantifier.oneOrMore((Quantifier.Mode)Quantifier.Mode.POSSESSIVE));
        new ParserTester("?+").assertParseQuantifier(Quantifier.onceOrNotAtAll((Quantifier.Mode)Quantifier.Mode.POSSESSIVE));
        new ParserTester("a").assertParseQuantifier(null);
        new ParserTester("").assertParseQuantifier(null);
        new ParserTester("{2}").assertParseQuantifier(Quantifier.exactly((Quantifier.Mode)Quantifier.Mode.GREEDY, (int)2));
        new ParserTester("{2,}").assertParseQuantifier(Quantifier.atLeast((Quantifier.Mode)Quantifier.Mode.GREEDY, (int)2));
        new ParserTester("{2,4}").assertParseQuantifier(Quantifier.between((Quantifier.Mode)Quantifier.Mode.GREEDY, (int)2, (int)4));
    }

    public void testParseBracketExpression() {
        new ParserTester("[a]").assertParseCharacterClass("[a]");
        new ParserTester("[^a]").assertParseCharacterClass("[^[a]]");
        new ParserTester("[^a-b]").assertParseCharacterClass("[^[a-b]]");
        new ParserTester("[a-b]").assertParseCharacterClass("[a-b]");
        new ParserTester("[ab]").assertParseCharacterClass("[[a]||[b]]");
        new ParserTester("[a&]").assertParseCharacterClass("[[a]||[&]]");
        new ParserTester("[a&&b]").assertParseCharacterClass("[[a]&&[b]]");
        new ParserTester("[a&&[^b]]").assertParseCharacterClass("[[a]&&[^[b]]]");
        new ParserTester("[a[^b]]").assertParseCharacterClass("[[a]||[^[b]]]");
        new ParserTester("[a[b]]").assertParseCharacterClass("[[a]||[b]]");
        new ParserTester("[a[b]c]").assertParseCharacterClass("[[a]||[[b]||[c]]]");
        new ParserTester("[[a]bc]").assertParseCharacterClass("[[a]||[[b]||[c]]]");
        new ParserTester("[-]").assertParseCharacterClass("[-]");
        new ParserTester("[a-]").assertParseCharacterClass("[[a]||[-]]");
        new ParserTester("[#--]").assertParseCharacterClass("[#--]");
    }

    private static class ParserTester {
        private final REParser parser;

        private ParserTester(CharSequence s) {
            this.parser = new REParser(s);
        }

        ParserTester assertParseCharacterClass(String expectedValue) {
            try {
                RENode.Expr node = this.parser.parseExpression();
                Assert.assertTrue((boolean)(node instanceof RENode.CharacterClass));
                Assert.assertEquals((String)expectedValue, (String)node.toString());
                return this;
            }
            catch (SyntaxException e) {
                throw AbstractTestCase.failure(e);
            }
        }

        ParserTester assertParseDisjunction(String expectedValue) {
            try {
                RENode.Disjunction disjunction = this.parser.parseDisjunction();
                Assert.assertTrue((boolean)this.parser.isDone());
                if (expectedValue.length() == 0) {
                    Assert.assertNull((Object)disjunction);
                } else {
                    Assert.assertNotNull((Object)disjunction);
                    Assert.assertEquals((String)expectedValue, (String)disjunction.toString());
                }
                return this;
            }
            catch (SyntaxException e) {
                throw AbstractTestCase.failure(e);
            }
        }

        ParserTester assertNotParseDisjunction() {
            int expectedIndex = this.parser.getIndex();
            try {
                this.parser.parseDisjunction();
                Assert.fail();
            }
            catch (SyntaxException e) {
                Assert.assertEquals((int)expectedIndex, (int)this.parser.getIndex());
            }
            return this;
        }

        ParserTester assertParseExpression(String expectedValue, int expectedIndex) {
            try {
                RENode.Expr exp = this.parser.parseExpression();
                Assert.assertEquals((String)expectedValue, (String)exp.toString());
                Assert.assertEquals((int)expectedIndex, (int)this.parser.getIndex());
                return this;
            }
            catch (SyntaxException e) {
                throw AbstractTestCase.failure(e);
            }
        }

        ParserTester assertNotParseExpression() {
            try {
                RENode.Expr expr = this.parser.parseExpression();
                Assert.assertNull((Object)expr);
            }
            catch (SyntaxException syntaxException) {
                // empty catch block
            }
            return this;
        }

        ParserTester assertParseQuantifier(Quantifier expectedQuantifier) {
            Quantifier quantifier;
            try {
                quantifier = this.parser.parseQuantifier();
            }
            catch (SyntaxException e) {
                throw AbstractTestCase.failure(e);
            }
            if (expectedQuantifier != null) {
                Assert.assertEquals((Object)expectedQuantifier, (Object)quantifier);
            } else {
                Assert.assertNull((Object)quantifier);
            }
            return this;
        }
    }
}

