/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router.regex;

import juzu.impl.router.regex.RENode;
import juzu.impl.router.regex.REParser;
import juzu.impl.router.regex.RERenderer;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class RegExpAnalyserTestCase
extends AbstractTestCase {
    private void assertAnalyse(String expectedPattern, String pattern) {
        try {
            RENode.Disjunction disjunction = new REParser((CharSequence)pattern).parseDisjunction();
            RegExpAnalyserTestCase.assertEquals((String)expectedPattern, (String)((StringBuilder)RERenderer.render((RENode)disjunction, (Appendable)new StringBuilder())).toString());
        }
        catch (Exception e) {
            RegExpAnalyserTestCase.fail(e);
        }
    }

    @Test
    public void testCharacterClass() {
        this.assertAnalyse("[a]", "[a]");
        this.assertAnalyse("[ab]", "[ab]");
        this.assertAnalyse("[ab]", "[a[b]]");
        this.assertAnalyse("[abc]", "[abc]");
        this.assertAnalyse("[abc]", "[[a]bc]");
        this.assertAnalyse("[abc]", "[a[b]c]");
        this.assertAnalyse("[abc]", "[ab[c]]");
        this.assertAnalyse("[abc]", "[[ab]c]");
        this.assertAnalyse("[abc]", "[a[bc]]");
        this.assertAnalyse("[abc]", "[[abc]]");
        this.assertAnalyse("[^a]", "[^a]");
    }

    @Test
    public void testGroupContainer() {
        this.assertAnalyse("(a)", "(a)");
        this.assertAnalyse("(a(?:b))", "(a(?:b))");
        this.assertAnalyse("(?:a(b))", "(?:a(b))");
        this.assertAnalyse("(a)(?:b)", "(a)(?:b)");
        this.assertAnalyse("(a(b))", "(a(b))");
        this.assertAnalyse("(a)(b)", "(a)(b)");
        this.assertAnalyse("(?=a)", "(?=a)");
        this.assertAnalyse("(?!a)", "(?!a)");
        this.assertAnalyse("(?<=a)", "(?<=a)");
        this.assertAnalyse("(?<!a)", "(?<!a)");
    }

    @Test
    public void testBilto() {
        this.assertAnalyse("[a]+", "[a]+");
    }
}

