/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router.regex;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import junit.framework.AssertionFailedError;
import juzu.impl.common.CharStream;
import juzu.impl.router.regex.Lexer;
import juzu.impl.router.regex.REParser;
import juzu.impl.router.regex.SyntaxException;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class RegExpParserTestCase
extends AbstractTestCase {
    @Test
    public void testParseDisjunction() {
        this.parseParse("|");
        this.parseParse("a|");
        this.parseParse("|a");
        this.parseParse("a|b");
    }

    @Test
    public void testParseAlternative() {
        this.parseParse("ab");
        this.parseParse("^a$");
    }

    @Test
    public void testParseAssertion() {
        this.parseParse("^");
        this.parseParse("$");
    }

    @Test
    public void testParseAny() {
        this.parseParse(".");
    }

    @Test
    public void testParseCharacterLiteral() {
        this.parseParse("a");
        this.parseParse("-");
        this.parseParse("]");
        this.parseParse("\\$");
        this.parseParse("\\00");
        this.parseParse("\\01");
        this.parseParse("\\018");
        this.parseParse("\\011");
        this.parseParse("\\0311");
        this.parseParse("\\x00");
        this.parseParse("\\xFF");
        this.parseParse("\\xff");
        this.parseParse("\\u0000");
        this.parseParse("\\uFFFF");
        this.failFail("\\");
        this.failFail("\\k");
        this.failFail("\\0");
        this.failFail("\\08");
        this.failFail("\\x1");
        this.failFail("\\x1G");
        this.failFail("\\u1");
        this.failFail("\\u12");
        this.failFail("\\u123");
        this.failFail("\\u123G");
    }

    @Test
    public void testCharacterClass() throws Exception {
        this.parseParse("[a]");
        this.parseParse("[{]");
        this.parseParse("[a{]");
        this.parseParse("[]a]");
        this.parseParse("[[a]]");
        this.parseParse("[a[b]]");
        this.failFail("[a");
        this.failFail("[]");
    }

    @Test
    public void testCharacterClassNegation() throws Exception {
        this.parseParse("[^a]");
        this.parseParse("[^]a]");
        this.parseParse("[^[a]]");
        this.parseParse("[^a[b]]");
        this.failFail("[^a");
        this.failFail("[]");
    }

    @Test
    public void testCharacterClassRange() {
        this.parseParse("[a-b]");
        this.parseParse("[-]");
        this.parseParse("[ --]");
        this.parseParse("[ --b]");
        this.parseParse("[--/]");
        this.parseParse("[a-]");
        this.parseParse("[---]");
        this.parseParse("[--]");
        this.parseFail("[--[ab]]");
    }

    @Test
    public void testCharacterClassAlternative() {
        this.parseParse("[&]");
        this.parseParse("[a&&b]");
        this.parseParse("[a&&]");
        this.parseParse("[a&&[b]]");
        this.failFail("[&&]");
        this.failFail("[&&&]");
        this.failFail("[&&&&]");
        this.parseFail("[&&b]");
    }

    @Test
    public void testCharacterClassEscape() {
        this.parseParse("[\\\\]");
        this.parseParse("[\\[]");
        this.parseParse("[\\]]");
        this.parseParse("[\\.]");
        this.parseParse("[\\-]");
        this.failFail("[\\k]");
    }

    @Test
    public void testCharacterClassAny() {
        this.parseParse("[.]");
        this.parseParse("[^.]");
    }

    @Test
    public void testCharacterClassAssert() {
        this.parseParse("[$]");
        this.parseParse("[^$]");
        this.parseParse("[^^]");
        this.parseParse("[$^]");
    }

    @Test
    public void testParseGroup() {
        this.parseParse("()");
        this.parseParse("(?)");
        this.parseParse("(a)");
        this.parseParse("(|)");
        this.parseParse("(a|)");
        this.parseParse("(|a)");
        this.parseParse("(a|b)");
        this.parseParse("(()())");
        this.parseParse("(?:)");
        this.parseParse("(?=)");
        this.parseParse("(?!)");
        this.parseParse("(?<=)");
        this.parseParse("(?<!)");
        this.failFail("(?a)");
        this.failFail("(");
        this.failFail(")");
        this.failFail("(?<)");
        this.failFail("(?<a)");
    }

    @Test
    public void testParseQuantifier() {
        this.parseParse("^?");
        this.parseParse("$?");
        this.parseParse("a?");
        this.parseParse("()?");
        this.parseParse("[a]?");
        this.parseParse("^*");
        this.parseParse("$*");
        this.parseParse("a*");
        this.parseParse("()*");
        this.parseParse("[a]*");
        this.parseParse("^+");
        this.parseParse("$+");
        this.parseParse("a+");
        this.parseParse("()+");
        this.parseParse("[a]+");
        this.parseParse("a{0}");
        this.parseParse("a{0,}");
        this.parseParse("a{0,1}");
        this.failFail("?");
        this.failFail("+");
        this.failFail("*");
        this.failFail("{");
        this.failFail("a{");
        this.failFail("a{}");
        this.failFail("a{b");
        this.failFail("a{0");
        this.failFail("a{0,");
        this.failFail("a{0,1");
    }

    @Test
    public void testParseQuantifierMode() {
        this.parseParse("a??");
        this.parseParse("a?+");
        this.parseParse("a+?");
        this.parseParse("a++");
        this.parseParse("a*?");
        this.parseParse("a*+");
        this.parseParse("a{0}?");
        this.parseParse("a{0}+");
    }

    void parseFail(String s) {
        this.parse(s, false, true);
    }

    void parseParse(String s) {
        this.parse(s, false, false);
    }

    void failFail(String s) {
        this.parse(s, true, true);
    }

    void parse(String s, boolean javaFail, boolean javaccFail) {
        block8: {
            block7: {
                try {
                    Pattern.compile(s);
                    if (javaFail) {
                        throw new AssertionFailedError("Was expecting " + s + " to not be compilable");
                    }
                }
                catch (PatternSyntaxException e) {
                    if (javaFail) break block7;
                    AssertionFailedError afe = new AssertionFailedError("Was expecting " + s + " to be compilable");
                    afe.initCause((Throwable)e);
                    throw afe;
                }
            }
            try {
                CharStream stream = new CharStream((CharSequence)s);
                Lexer lexer = new Lexer(stream);
                REParser parser = new REParser(lexer);
                parser.parse();
                RegExpParserTestCase.assertEquals((int)s.length(), (int)stream.getIndex());
                if (lexer.hasNext()) {
                    throw new SyntaxException();
                }
                if (javaccFail) {
                    throw new AssertionFailedError("Was expecting " + s + " to not be compilable");
                }
            }
            catch (SyntaxException e) {
                if (javaccFail) break block8;
                AssertionFailedError afe = new AssertionFailedError("Was expecting " + s + " to be compilable");
                afe.initCause((Throwable)e);
                throw afe;
            }
        }
    }
}

