/*
 * Decompiled with CFR 0.152.
 */
package juzu.test;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import juzu.impl.common.JSON;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.test.CompilerAssert;
import juzu.test.Registry;
import juzu.test.protocol.mock.MockApplication;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTestCase
extends Assert {
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        Registry.clear();
    }

    @After
    public void tearDown() {
    }

    public static long waitForOneMillis() {
        long snapshot = System.currentTimeMillis();
        try {
            while (true) {
                long now;
                if (snapshot < (now = System.currentTimeMillis())) {
                    return now;
                }
                snapshot = now;
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException e) {
            AssertionFailedError afe = new AssertionFailedError("Was not expecting interruption");
            afe.initCause((Throwable)e);
            throw afe;
        }
    }

    public static void fail(Throwable t) {
        throw AbstractTestCase.failure(t);
    }

    public static AssertionFailedError failure(Throwable t) {
        AssertionFailedError afe = new AssertionFailedError();
        afe.initCause(t);
        return afe;
    }

    public static AssertionFailedError failure(String msg, Throwable t) {
        AssertionFailedError afe = new AssertionFailedError(msg);
        afe.initCause(t);
        return afe;
    }

    public static AssertionFailedError failure(String msg) {
        return new AssertionFailedError(msg);
    }

    public static <T> T assertInstanceOf(Class<T> expectedInstance, Object o) {
        if (expectedInstance.isInstance(o)) {
            return expectedInstance.cast(o);
        }
        throw AbstractTestCase.failure("Was expecting " + o + " to be an instance of " + expectedInstance.getName());
    }

    public static <T> T assertNotInstanceOf(Class<?> expectedInstance, T o) {
        if (expectedInstance.isInstance(o)) {
            throw AbstractTestCase.failure("Was expecting " + o + " not to be an instance of " + expectedInstance.getName());
        }
        return o;
    }

    public static void assertDelete(File f) {
        if (!f.exists()) {
            throw AbstractTestCase.failure("Was expecting file " + f.getAbsolutePath() + " to exist");
        }
        if (!f.delete()) {
            throw AbstractTestCase.failure("Was expecting file " + f.getAbsolutePath() + " to be deleted");
        }
    }

    public static DiskFileSystem diskFS(Name packageName) {
        File root = new File(System.getProperty("juzu.test.resources.path"));
        return new DiskFileSystem(root, packageName);
    }

    public static DiskFileSystem diskFS(String packageName) {
        File root = new File(System.getProperty("juzu.test.resources.path"));
        return new DiskFileSystem(root, packageName);
    }

    public final String getName() {
        return this.name.getMethodName();
    }

    public final CompilerAssert<File, File> compiler(String packageName) {
        return this.compiler(false, packageName);
    }

    public final CompilerAssert<File, File> incrementalCompiler(String packageName) {
        return this.compiler(true, packageName);
    }

    private CompilerAssert<File, File> compiler(boolean incremental, String packageName) {
        return AbstractTestCase.compiler(incremental, Name.parse((CharSequence)packageName), this.getQualifiers());
    }

    protected ArrayList<String> getQualifiers() {
        ArrayList<String> qualifiers = new ArrayList<String>();
        String methodName = this.name.getMethodName();
        if (methodName != null) {
            qualifiers.add(methodName);
        }
        return qualifiers;
    }

    public static CompilerAssert<File, File> compiler(boolean incremental, Name packageName, String ... qualifiers) {
        return AbstractTestCase.compiler(incremental, packageName, Arrays.asList(qualifiers));
    }

    private static CompilerAssert<File, File> compiler(boolean incremental, Name packageName, List<String> qualifiers) {
        if (packageName.isEmpty()) {
            throw AbstractTestCase.failure("Cannot compile empty package");
        }
        String outputPath = System.getProperty("juzu.test.workspace.path");
        File a = new File(outputPath);
        if (a.exists()) {
            if (a.isFile()) {
                throw AbstractTestCase.failure("File " + outputPath + " already exist and is a file");
            }
        } else if (!a.mkdirs()) {
            throw AbstractTestCase.failure("Could not create test generated source directory " + outputPath);
        }
        StringBuilder pkg = Tools.join((StringBuilder)new StringBuilder(), (char)'_', (Iterable)packageName);
        if (qualifiers != null) {
            for (String qualifier : qualifiers) {
                pkg.append('#').append(qualifier);
            }
        }
        File f2 = new File(a, pkg.toString());
        int count = 0;
        while (f2.exists()) {
            f2 = new File(a, pkg + "-" + count);
            ++count;
        }
        if (!f2.mkdirs()) {
            throw AbstractTestCase.failure("Could not create test generated source directory " + f2.getAbsolutePath());
        }
        File sourceOutputDir = new File(f2, "source-output");
        AbstractTestCase.assertTrue((boolean)sourceOutputDir.mkdir());
        DiskFileSystem sourceOutput = new DiskFileSystem(sourceOutputDir);
        File classOutputDir = new File(f2, "class-output");
        AbstractTestCase.assertTrue((boolean)classOutputDir.mkdir());
        DiskFileSystem classOutput = new DiskFileSystem(classOutputDir);
        DiskFileSystem input = AbstractTestCase.diskFS(packageName);
        File sourcePathDir = new File(f2, "source-path");
        AbstractTestCase.assertTrue((boolean)sourcePathDir.mkdir());
        DiskFileSystem sourcePath = new DiskFileSystem(sourcePathDir);
        try {
            input.copy((ReadWriteFileSystem)sourcePath);
        }
        catch (IOException e) {
            throw AbstractTestCase.failure(e);
        }
        return new CompilerAssert<File, File>(incremental, (ReadWriteFileSystem<File>)sourcePath, (ReadWriteFileSystem<File>)sourceOutput, (ReadWriteFileSystem<File>)classOutput);
    }

    public MockApplication<?> application(InjectorProvider injectImplementation, String packageName) {
        CompilerAssert<File, File> helper = this.compiler(packageName);
        helper.assertCompile();
        return helper.application(injectImplementation, Name.parse((CharSequence)packageName));
    }

    public static void assertEquals(JSON expected, JSON test) {
        if (expected != null) {
            if (test == null) {
                throw AbstractTestCase.failure("Was expected " + expected + " to be not null");
            }
            if (!AbstractTestCase.equalsIgnoreNull(expected, test)) {
                try {
                    StringBuilder sb = new StringBuilder("expected <");
                    expected.toString((Appendable)sb, 2);
                    sb.append(">  but was:<");
                    test.toString((Appendable)sb, 2);
                    sb.append(">");
                    throw AbstractTestCase.failure(sb.toString());
                }
                catch (IOException e) {
                    throw AbstractTestCase.failure("Unexpected", e);
                }
            }
        } else if (test != null) {
            throw AbstractTestCase.failure("Was expected " + test + " to be null");
        }
    }

    private static boolean equalsIgnoreNull(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return true;
        }
        if (o1 instanceof List && o2 instanceof List) {
            boolean n2;
            boolean n1;
            block5: {
                Iterator i1 = ((List)o1).iterator();
                Iterator i2 = ((List)o2).iterator();
                do {
                    n1 = i1.hasNext();
                    n2 = i2.hasNext();
                    if (!n1 || !n2) break block5;
                } while (AbstractTestCase.equalsIgnoreNull(i1.next(), i2.next()));
                return false;
            }
            return n1 == n2;
        }
        if (o1 instanceof JSON && o2 instanceof JSON) {
            JSON js1 = (JSON)o1;
            JSON js2 = (JSON)o2;
            HashSet names = new HashSet(js1.names());
            names.addAll(js2.names());
            for (String name : names) {
                Object v2;
                js1.getArray("", Object.class);
                Object v1 = js1.get(name);
                if (AbstractTestCase.equalsIgnoreNull(v1, v2 = js2.get(name))) continue;
                return false;
            }
            return true;
        }
        return o1.equals(o2);
    }

    public static void assertNoSuchElement(Iterator<?> iterator) {
        try {
            Object next = iterator.next();
            AbstractTestCase.fail((String)("Was not expecting to obtain " + next + " element from an iterator"));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public static <E> void assertEquals(List<? extends E> expected, Iterable<? extends E> test) {
        int index = 0;
        Iterator<E> expectedIterator = expected.iterator();
        Iterator<E> testIterator = test.iterator();
        while (expectedIterator.hasNext()) {
            if (testIterator.hasNext()) {
                E testNext;
                E expectedNext = expectedIterator.next();
                if (!Tools.safeEquals(expectedNext, testNext = testIterator.next())) {
                    throw AbstractTestCase.failure("Elements at index " + index + " are not equals: " + expectedNext + "!=" + testNext);
                }
                ++index;
                continue;
            }
            throw AbstractTestCase.failure("Tested iterable has more elements than the expected iterable at index " + index);
        }
        if (testIterator.hasNext()) {
            throw AbstractTestCase.failure("Expected iterable has more elements than the tested iterable at index " + index);
        }
    }
}

