/*
 * Decompiled with CFR 0.152.
 */
package juzu.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Processor;
import javax.inject.Provider;
import javax.tools.JavaCompiler;
import junit.framework.Assert;
import juzu.impl.common.Tools;
import juzu.impl.compiler.CompilationException;
import juzu.impl.compiler.Compiler;
import juzu.impl.compiler.CompilerConfig;
import juzu.impl.fs.Change;
import juzu.impl.fs.FileSystemScanner;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.test.JavaCompilerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompileStrategy<I, O> {
    final ReadFileSystem<?> classPath;
    final ReadWriteFileSystem<I> sourcePath;
    final ReadWriteFileSystem<O> sourceOutput;
    final ReadWriteFileSystem<O> classOutput;
    JavaCompilerProvider javaCompilerProvider;
    Provider<? extends Processor> processorFactory;
    final CompilerConfig config;
    Compiler compiler;
    private static final Pattern javaFilePattern = Pattern.compile("(.+)\\.java");

    public CompileStrategy(ReadFileSystem<?> classPath, ReadWriteFileSystem<I> sourcePath, ReadWriteFileSystem<O> sourceOutput, ReadWriteFileSystem<O> classOutput) {
        this.classPath = classPath;
        this.sourcePath = sourcePath;
        this.sourceOutput = sourceOutput;
        this.classOutput = classOutput;
        this.config = new CompilerConfig().force(true);
    }

    final Compiler.Builder builder() {
        Compiler.Builder builder = Compiler.builder();
        JavaCompiler abc = this.javaCompilerProvider.get();
        builder.javaCompiler(abc);
        builder.processor(this.processorFactory);
        builder.addClassPath(this.classPath);
        builder.sourcePath(this.sourcePath);
        builder.sourceOutput(this.sourceOutput);
        builder.classOutput(this.classOutput);
        builder.config(this.config);
        return builder;
    }

    abstract void compile() throws IOException, CompilationException;

    abstract void addClassPath(ReadFileSystem<?> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Batch<I, O>
    extends CompileStrategy<I, O> {
        public Batch(ReadFileSystem<?> classPath, ReadWriteFileSystem<I> sourcePath, ReadWriteFileSystem<O> sourceOutput, ReadWriteFileSystem<O> classOutput) {
            super(classPath, sourcePath, sourceOutput, classOutput);
        }

        @Override
        void compile() throws IOException, CompilationException {
            this.compiler = this.builder().build();
            this.compiler.compile();
        }

        @Override
        void addClassPath(ReadFileSystem<?> classPath) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Incremental<I, O>
    extends CompileStrategy<I, O> {
        final LinkedList<ReadFileSystem<?>> classPath = new LinkedList();
        final FileSystemScanner<I> scanner;

        public Incremental(ReadFileSystem<?> classPath, ReadWriteFileSystem<I> sourcePath, ReadWriteFileSystem<O> sourceOutput, ReadWriteFileSystem<O> classOutput) {
            super(classPath, sourcePath, sourceOutput, classOutput);
            this.scanner = FileSystemScanner.createHashing(sourcePath);
        }

        @Override
        void compile() throws IOException, CompilationException {
            Compiler.Builder builder = this.builder();
            ArrayList<String> toCompile = new ArrayList<String>();
            ArrayList<String> toDelete = new ArrayList<String>();
            for (Map.Entry entry : this.scanner.scan().entrySet()) {
                String path = (String)entry.getKey();
                if (!path.endsWith(".java")) continue;
                switch ((Change)entry.getValue()) {
                    case REMOVE: {
                        toDelete.add(path);
                        break;
                    }
                    case ADD: {
                        toCompile.add(path);
                        break;
                    }
                    case UPDATE: {
                        toCompile.add(path);
                        toDelete.add(path);
                    }
                }
            }
            for (String string : toDelete) {
                Matcher matcher = javaFilePattern.matcher(string);
                Assert.assertTrue((boolean)matcher.matches());
                String path = matcher.group(1) + ".class";
                String[] names = Tools.split((CharSequence)path, (char)'/');
                Object clazz = this.classOutput.getPath(names);
                if (clazz == null) continue;
                this.classOutput.removePath(clazz);
            }
            for (ReadFileSystem readFileSystem : this.classPath) {
                builder.addClassPath(readFileSystem);
            }
            this.compiler = builder.build();
            this.compiler.compile(toCompile.toArray(new String[toCompile.size()]));
        }

        @Override
        void addClassPath(ReadFileSystem<?> classPath) {
            this.classPath.add(classPath);
        }
    }
}

