/*
 * Decompiled with CFR 0.152.
 */
package juzu.test.protocol.http;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetServer;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.common.MethodHandle;
import juzu.impl.plugin.application.ApplicationContext;
import juzu.impl.plugin.application.ApplicationLifeCycle;
import juzu.impl.request.Method;
import juzu.request.Phase;
import juzu.test.protocol.http.AbstractHttpTestCase;
import juzu.test.protocol.http.ActionBridgeImpl;
import juzu.test.protocol.http.RenderBridgeImpl;
import juzu.test.protocol.http.RequestBridgeImpl;
import juzu.test.protocol.http.ResourceBridgeImpl;

public class HttpServletImpl
extends HttpServlet {
    private ApplicationLifeCycle<?, ?> application;
    private AssetServer assetServer;
    AssetManager scriptManager;
    AssetManager stylesheetManager;

    private RequestBridgeImpl create(HttpServletRequest req, HttpServletResponse resp) {
        MethodHandle method;
        Phase.View phase = Phase.VIEW;
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        String methodId = null;
        for (Map.Entry entry : req.getParameterMap().entrySet()) {
            String name = (String)entry.getKey();
            String[] value = (String[])entry.getValue();
            if (name.equals("juzu.phase")) {
                phase = Phase.valueOf((String)value[0]);
                continue;
            }
            if (name.equals("juzu.op")) {
                methodId = value[0];
                continue;
            }
            parameters.put(name, value);
        }
        MethodHandle methodHandle = method = methodId != null ? this.application.getDescriptor().getControllers().getMethodById(methodId).getHandle() : null;
        if (method == null) {
            Method descriptor = (Method)this.application.getContext().getDescriptor().getControllers().getResolver().resolve((Phase)Phase.VIEW, Collections.emptySet());
            MethodHandle methodHandle2 = method = descriptor != null ? descriptor.getHandle() : null;
        }
        if (phase == Phase.ACTION) {
            return new ActionBridgeImpl(this.application.getContext(), req, resp, method, parameters);
        }
        if (phase == Phase.VIEW) {
            return new RenderBridgeImpl(this, this.application.getContext(), req, resp, method, parameters);
        }
        if (phase == Phase.RESOURCE) {
            return new ResourceBridgeImpl(this.application.getContext(), req, resp, method, parameters);
        }
        throw new AssertionError();
    }

    public void init() throws ServletException {
        try {
            ApplicationLifeCycle<?, ?> application = AbstractHttpTestCase.getCurrentApplication();
            application.refresh();
            this.assetServer = new AssetServer();
            this.scriptManager = application.getScriptManager();
            this.stylesheetManager = application.getStylesheetManager();
            this.assetServer.register(application);
            this.application = application;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        this.assetServer.unregister(this.application);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getRequestURI().substring(req.getContextPath().length());
        String contentType = path.endsWith(".js") ? "text/javascript" : (path.endsWith(".css") ? "text/css" : null);
        if (contentType != null) {
            if (!this.assetServer.doGet(path, this.getServletContext(), resp)) {
                resp.sendError(404, "Path " + path + " could not be resolved");
            }
        } else {
            RequestBridgeImpl requestBridge = this.create(req, resp);
            try {
                ApplicationContext context = this.application.getContext();
                context.invoke((RequestBridge)requestBridge);
            }
            finally {
                requestBridge.close();
            }
        }
    }
}

