/*
 * Decompiled with CFR 0.152.
 */
package juzu.test.protocol.mock;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import juzu.Response;
import juzu.impl.bridge.spi.ActionBridge;
import juzu.impl.bridge.spi.DispatchSPI;
import juzu.impl.common.MethodHandle;
import juzu.impl.plugin.application.ApplicationContext;
import juzu.request.ClientContext;
import juzu.request.Phase;
import juzu.test.AbstractTestCase;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockRequestBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockActionBridge
extends MockRequestBridge
implements ActionBridge {
    private Response response;

    public MockActionBridge(ApplicationContext application, MockClient client, MethodHandle target, Map<String, String[]> parameters) {
        super(application, client, target, parameters);
    }

    public ClientContext getClientContext() {
        throw new UnsupportedOperationException();
    }

    public String assertUpdate() {
        if (this.response instanceof Response.View) {
            Response.View update = (Response.View)this.response;
            DispatchSPI spi = this.createDispatch((Phase)Phase.VIEW, update.getTarget(), update.getParameters());
            Phase.View.Dispatch dispatch = new Phase.View.Dispatch(spi);
            return dispatch.with(update.getProperties()).toString();
        }
        throw AbstractTestCase.failure("Was expecting an update instead of " + this.response);
    }

    public void assertNoResponse() {
        this.assertResponse(null);
    }

    public void assertRedirect(String location) {
        this.assertResponse((Response)new Response.Redirect(location));
    }

    public void assertRender(final MethodHandle expectedTarget, Map<String, String> expectedArguments) {
        final HashMap<String, String[]> a = new HashMap<String, String[]>();
        for (Map.Entry<String, String> entry : expectedArguments.entrySet()) {
            a.put(entry.getKey(), new String[]{entry.getValue()});
        }
        Response.View resp = new Response.View(){

            public MethodHandle getTarget() {
                return expectedTarget;
            }

            public Map<String, String[]> getParameters() {
                return a;
            }
        };
        this.assertResponse((Response)resp);
    }

    public void assertRender(String expectedTarget, Map<String, String> expectedArguments) {
        this.assertRender(this.application.getDescriptor().getControllers().getMethodById(expectedTarget).getHandle(), expectedArguments);
    }

    private void assertResponse(Response expectedResponse) {
        if (expectedResponse instanceof Response.View) {
            Response.View expected = (Response.View)expectedResponse;
            Response.View resp = (Response.View)this.response;
            AbstractTestCase.assertEquals((int)expected.getParameters().size(), (int)expected.getParameters().size());
            for (String key : resp.getParameters().keySet()) {
                AbstractTestCase.assertEquals(Arrays.asList((Object[])expected.getParameters().get(key)), Arrays.asList((Object[])resp.getParameters().get(key)));
            }
        } else {
            AbstractTestCase.assertEquals((String)("Was expecting a response " + expectedResponse + " instead of  " + this.response), (Object)expectedResponse, (Object)this.response);
        }
    }

    public void setResponse(Response response) throws IllegalStateException, IOException {
        if (!(response instanceof Response.View) && !(response instanceof Response.Redirect)) {
            throw new IllegalArgumentException();
        }
        this.response = response;
    }
}

