/*
 * Decompiled with CFR 0.152.
 */
package juzu.test.protocol.mock;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import juzu.impl.common.JSON;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.Tools;
import juzu.impl.inject.Scoped;
import juzu.impl.inject.ScopedContext;
import juzu.impl.plugin.application.ApplicationException;
import juzu.impl.plugin.controller.descriptor.ControllersDescriptor;
import juzu.impl.request.Method;
import juzu.request.Phase;
import juzu.test.AbstractTestCase;
import juzu.test.protocol.mock.MockActionBridge;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockRenderBridge;
import juzu.test.protocol.mock.MockRequestBridge;
import juzu.test.protocol.mock.MockResourceBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockClient {
    final MockApplication<?> application;
    private final ControllersDescriptor controllers;
    private ScopedContext session;
    private ScopedContext flash;
    private final LinkedList<List<Scoped>> flashHistory;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MockRequestBridge create(String url) {
        try {
            void var2_13;
            JSON json = (JSON)JSON.parse((String)url);
            JSON jsonParams = json.getJSON("parameters");
            HashMap<String, String[]> parameters = new HashMap<String, String[]>();
            for (String name : jsonParams.names()) {
                List value = jsonParams.getList(name, String.class);
                parameters.put(name, value.toArray(new String[value.size()]));
            }
            Method method = null;
            if (json.getString("target") != null) {
                MethodHandle target = MethodHandle.parse((String)json.getString("target"));
                method = this.application.getContext().getDescriptor().getControllers().getMethodByHandle(target);
            }
            if (method != null) {
                if (method.getPhase() == Phase.ACTION) {
                    MockActionBridge mockActionBridge = new MockActionBridge(this.application.getContext(), this, method.getHandle(), parameters);
                    return var2_13;
                } else if (method.getPhase() == Phase.VIEW) {
                    MockRenderBridge mockRenderBridge = new MockRenderBridge(this.application.getContext(), this, method.getHandle(), parameters);
                    return var2_13;
                } else {
                    if (method.getPhase() != Phase.RESOURCE) throw new AssertionError();
                    MockResourceBridge mockResourceBridge = new MockResourceBridge(this.application.getContext(), this, method.getHandle(), parameters);
                }
                return var2_13;
            } else {
                MockRenderBridge mockRenderBridge = new MockRenderBridge(this.application.getContext(), this, null, parameters);
            }
            return var2_13;
        }
        catch (Exception e) {
            throw AbstractTestCase.failure(e);
        }
    }

    public MockClient(MockApplication<?> application) {
        this.application = application;
        this.session = new ScopedContext();
        this.flash = null;
        this.flashHistory = new LinkedList();
        this.controllers = application.getContext().getDescriptor().getControllers();
    }

    public MockRenderBridge render(String methodId) throws ApplicationException {
        MethodHandle handle = null;
        Method method = null;
        method = methodId != null ? this.controllers.getMethodById(methodId) : (Method)this.controllers.getResolver().resolve((Phase)Phase.VIEW, Collections.emptySet());
        if (method != null) {
            handle = method.getHandle();
        }
        MockRenderBridge render = new MockRenderBridge(this.application.getContext(), this, handle, new HashMap<String, String[]>());
        this.invoke(render);
        return render;
    }

    public MockRenderBridge render() throws ApplicationException {
        return this.render(null);
    }

    public MockRequestBridge invoke(String url) throws ApplicationException {
        MockRequestBridge request = this.create(url);
        this.invoke(request);
        return request;
    }

    public Scoped getFlashValue(Object key) {
        return this.flash != null ? this.flash.get(key) : null;
    }

    public void setFlashValue(Object key, Scoped value) {
        if (this.flash == null) {
            this.flash = new ScopedContext();
        }
        this.flash.set(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(MockRequestBridge request) throws ApplicationException {
        try {
            this.application.invoke(request);
        }
        finally {
            request.close();
            if (request instanceof MockRenderBridge) {
                if (this.flash != null) {
                    this.flashHistory.addFirst(Tools.list((Iterable)this.flash));
                    this.flash.close();
                    this.flash = null;
                } else {
                    this.flashHistory.addFirst(Collections.emptyList());
                }
            }
        }
    }

    public List<Scoped> getFlashHistory(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Wrong index " + index);
        }
        if (index == 0) {
            return Tools.list((Iterable)this.flash);
        }
        return this.flashHistory.get(index - 1);
    }

    public ScopedContext getSession() {
        return this.session;
    }

    public void invalidate() {
        this.session.close();
        this.session = new ScopedContext();
    }
}

