/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import juzu.Response;
import juzu.bridge.portlet.JuzuPortlet;
import juzu.impl.asset.AssetServer;
import juzu.impl.bridge.BridgeConfig;
import juzu.impl.bridge.EventBridge;
import juzu.impl.bridge.spi.ActionBridge;
import juzu.impl.bridge.spi.RenderBridge;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.bridge.spi.ResourceBridge;
import juzu.impl.common.Logger;
import juzu.impl.common.Tools;
import juzu.impl.common.TrimmingException;
import juzu.impl.compiler.CompilationError;
import juzu.impl.compiler.CompilationException;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.plugin.application.ApplicationException;
import juzu.impl.plugin.application.ApplicationLifeCycle;
import juzu.impl.plugin.module.ModuleLifeCycle;
import juzu.impl.resource.ResourceResolver;
import juzu.io.Stream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bridge {
    public Logger log;
    public AssetServer server;
    public BridgeConfig config;
    public ReadFileSystem<?> resources;
    public ClassLoader classLoader;
    public ApplicationLifeCycle runtime;
    public ResourceResolver resolver;
    private ModuleLifeCycle module;

    public Bridge(ModuleLifeCycle module) {
        this.module = module;
    }

    public void boot() throws Exception, CompilationException {
        if (this.runtime == null) {
            this.runtime = new ApplicationLifeCycle(this.log, this.module);
            this.runtime.setResources(this.resources);
            this.runtime.setInjectImplementation(this.config.injectImpl);
            this.runtime.setName(this.config.name);
            this.runtime.setAssetServer(this.server);
            this.runtime.setResolver(this.resolver);
        }
        this.runtime.refresh();
    }

    public void invoke(RequestBridge requestBridge) throws Throwable {
        if (requestBridge instanceof ActionBridge) {
            this.processAction((ActionBridge)requestBridge);
        } else if (requestBridge instanceof RenderBridge) {
            this.render((RenderBridge)requestBridge);
        } else if (requestBridge instanceof ResourceBridge) {
            this.serveResource((ResourceBridge)requestBridge);
        } else {
            throw new AssertionError();
        }
    }

    public void processAction(final ActionBridge requestBridge) throws Throwable {
        try {
            TrimmingException.invoke(new TrimmingException.Callback(){

                public void call() throws Throwable {
                    try {
                        Bridge.this.runtime.getContext().invoke(requestBridge);
                    }
                    catch (ApplicationException e) {
                        throw e.getCause();
                    }
                }
            });
        }
        catch (TrimmingException e) {
            throw e.getSource();
        }
        finally {
            requestBridge.close();
        }
    }

    public void processEvent(final EventBridge requestBridge) throws Throwable {
        try {
            TrimmingException.invoke(new TrimmingException.Callback(){

                public void call() throws Throwable {
                    try {
                        Bridge.this.runtime.getContext().invoke(requestBridge);
                    }
                    catch (ApplicationException e) {
                        throw e.getCause();
                    }
                }
            });
        }
        catch (TrimmingException e) {
            throw e.getSource();
        }
        finally {
            requestBridge.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(final RenderBridge requestBridge) throws Throwable {
        List<CompilationError> errors = null;
        try {
            this.boot();
        }
        catch (CompilationException e) {
            errors = e.getErrors();
        }
        if (errors == null || errors.isEmpty()) {
            if (errors != null) {
                requestBridge.purgeSession();
            }
            try {
                TrimmingException.invoke(new TrimmingException.Callback(){

                    public void call() throws Throwable {
                        try {
                            Bridge.this.runtime.getContext().invoke(requestBridge);
                        }
                        catch (ApplicationException e) {
                            throw e.getCause();
                        }
                    }
                });
            }
            catch (TrimmingException e) {
                if (this.config.isProd()) {
                    throw e.getSource();
                }
                StringWriter writer = new StringWriter();
                PrintWriter printer = new PrintWriter(writer);
                this.renderThrowable(printer, e);
                requestBridge.setResponse(Response.ok(writer.getBuffer()));
            }
            finally {
                requestBridge.close();
            }
        } else {
            try {
                StringWriter writer = new StringWriter();
                PrintWriter printer = new PrintWriter(writer);
                this.renderErrors(printer, errors);
                requestBridge.setResponse(Response.ok(writer.getBuffer()));
            }
            finally {
                requestBridge.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveResource(final ResourceBridge requestBridge) throws Throwable {
        try {
            TrimmingException.invoke(new TrimmingException.Callback(){

                public void call() throws Throwable {
                    try {
                        Bridge.this.runtime.getContext().invoke(requestBridge);
                    }
                    catch (ApplicationException e) {
                        throw e.getCause();
                    }
                }
            });
        }
        catch (TrimmingException e) {
            Response.Content<Stream.Char> response;
            this.logThrowable(e);
            if (!this.config.isProd()) {
                StringWriter writer = new StringWriter();
                PrintWriter printer = new PrintWriter(writer);
                printer.print("<html>\n");
                printer.print("<head>\n");
                printer.print("</head>\n");
                printer.print("<body>\n");
                this.renderThrowable(printer, e);
                printer.print("</body>\n");
                response = Response.content(500, writer.getBuffer());
            } else {
                response = Response.content(500, "todo");
            }
            requestBridge.setResponse(response);
        }
        finally {
            requestBridge.close();
        }
    }

    private void logThrowable(Throwable t) {
        this.log.log(t.getMessage(), t);
    }

    private void renderThrowable(PrintWriter writer, Throwable t) throws IOException {
        StackTraceElement[] trace;
        int size = 0;
        for (StackTraceElement element : trace = t.getStackTrace()) {
            if (element.getClassName().equals(JuzuPortlet.class.getName())) break;
            ++size;
        }
        StackTraceElement[] ourTrace = new StackTraceElement[size];
        System.arraycopy(trace, 0, ourTrace, 0, ourTrace.length);
        t.setStackTrace(ourTrace);
        this.sendJuzuCSS(writer);
        final AtomicBoolean open = new AtomicBoolean(false);
        PrintWriter formatter = new PrintWriter(writer){

            public void println(Object x) {
                if (open.get()) {
                    super.append("</ul></pre>");
                }
                super.append("<div class=\"juzu-message\">");
                super.append(String.valueOf(x));
                super.append("</div>");
                open.set(false);
            }

            public void println(String x) {
                if (!open.get()) {
                    super.append("<pre><ul>");
                    open.set(true);
                }
                super.append("<li><span>");
                super.append(x);
                super.append("</span></li>");
            }

            public void println() {
            }
        };
        writer.append("<div class=\"juzu\">");
        writer.append("<div class=\"juzu-box\">");
        t.printStackTrace(formatter);
        if (open.get()) {
            writer.append("</ul></pre>");
        }
        writer.append("</div>");
        writer.append("</div>");
    }

    private void sendJuzuCSS(PrintWriter writer) throws IOException {
        URL cssURL = JuzuPortlet.class.getResource("juzu.css");
        String css = Tools.read(cssURL);
        css = css.replace("\"", "\\\"");
        css = css.replace("'", "\\'");
        css = css.replace("\n", "\\n");
        writer.append("<script type='text/javascript'>\n");
        writer.append("var styleElement = document.createElement('style');\n");
        writer.append("var css = '");
        writer.append(css);
        writer.append("';\n");
        writer.append("styleElement.type = 'text/css';\n");
        writer.append("if (styleElement.styleSheet) {;\n");
        writer.append("styleElement.styleSheet.cssText = css;\n");
        writer.append("} else {\n");
        writer.append("styleElement.appendChild(document.createTextNode(css));\n");
        writer.append("}\n");
        writer.append("document.getElementsByTagName(\"head\")[0].appendChild(styleElement);\n");
        writer.append("</script>\n");
    }

    private void renderErrors(PrintWriter writer, Collection<CompilationError> errors) throws IOException {
        this.sendJuzuCSS(writer);
        writer.append("<div class=\"juzu\">");
        for (CompilationError error : errors) {
            writer.append("<div class=\"juzu-box\">");
            writer.append("<div class=\"juzu-message\">").append(error.getMessage()).append("</div>");
            File source = error.getSourceFile();
            if (source != null) {
                int line = error.getLocation().getLine();
                int from = line - 2;
                int to = line + 3;
                BufferedReader reader = new BufferedReader(new FileReader(source));
                int count = 1;
                writer.append("<pre><ol start=\"").append(String.valueOf(from)).append("\">");
                String s = reader.readLine();
                while (s != null) {
                    if (count >= from && count < to) {
                        if (count == line) {
                            writer.append("<li><span class=\"error\">").append(s).append("</span></li>");
                        } else {
                            writer.append("<li><span>").append(s).append("</span></li>");
                        }
                    }
                    ++count;
                    s = reader.readLine();
                }
                writer.append("</ol></pre>");
            }
            writer.append("</div>");
        }
        writer.append("</div>");
    }
}

