/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.servlet;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletException;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.servlet.ServletBridge;
import juzu.impl.common.MethodHandle;
import juzu.impl.plugin.router.RouteDescriptor;
import juzu.impl.router.Route;
import juzu.request.Phase;

class Handler {
    final Bridge bridge;
    final Route root;
    final HashMap<MethodHandle, Route> routeMap;
    final HashMap<Route, Map<Phase, MethodHandle>> routeMap2;
    final HashSet<Route> routes;

    Handler(Route parent, Bridge bridge) throws ServletException {
        this.bridge = bridge;
        try {
            Route root;
            bridge.boot();
            HashMap<MethodHandle, Route> routeMap = new HashMap<MethodHandle, Route>();
            HashMap<Route, HashMap<Phase, MethodHandle>> routeMap2 = new HashMap<Route, HashMap<Phase, MethodHandle>>();
            HashSet<Route> routes = new HashSet<Route>();
            RouteDescriptor routesDesc = (RouteDescriptor)bridge.runtime.getDescriptor().getPluginDescriptor("router");
            if (routesDesc != null) {
                Map<RouteDescriptor, Route> ret = routesDesc.getPath() != null ? routesDesc.popupate(parent) : routesDesc.create();
                root = ret.values().iterator().next();
                for (Map.Entry<RouteDescriptor, Route> entry : ret.entrySet()) {
                    for (Map.Entry<String, String> entry2 : entry.getKey().getTargets().entrySet()) {
                        MethodHandle handle = MethodHandle.parse(entry2.getValue());
                        Phase phase = Phase.valueOf(entry2.getKey());
                        routeMap.put(handle, entry.getValue());
                        HashMap<Phase, MethodHandle> map = (HashMap<Phase, MethodHandle>)routeMap2.get(entry.getValue());
                        if (map == null) {
                            map = new HashMap<Phase, MethodHandle>();
                            routeMap2.put(entry.getValue(), map);
                        }
                        map.put(phase, handle);
                    }
                    routes.add(entry.getValue());
                }
            } else {
                root = parent.append("/" + bridge.runtime.getName().getIdentifier());
                routes.add(root);
            }
            this.routes = routes;
            this.root = root;
            this.routeMap = routeMap;
            this.routeMap2 = routeMap2;
        }
        catch (Exception e) {
            throw ServletBridge.wrap(e);
        }
    }
}

