/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.application;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import juzu.Application;
import juzu.Scope;
import juzu.impl.common.Filter;
import juzu.impl.common.Tools;
import juzu.impl.inject.BeanDescriptor;
import juzu.impl.inject.spi.BeanLifeCycle;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.Injector;
import juzu.impl.plugin.application.ApplicationContext;
import juzu.impl.plugin.application.ApplicationException;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ApplicationBootstrap {
    public final Injector injector;
    public final ApplicationDescriptor descriptor;
    private BeanLifeCycle<ApplicationContext> contextLifeCycle;
    private InjectionContext<?, ?> injectionContext;

    ApplicationBootstrap(Injector injector, ApplicationDescriptor descriptor) {
        this.injector = injector;
        this.descriptor = descriptor;
    }

    void start() throws ApplicationException {
        this._start();
    }

    private <B, I> void _start() throws ApplicationException {
        InjectionContext<?, ?> injectionContext;
        this.injector.bindBean(ApplicationDescriptor.class, null, this.descriptor);
        this.injector.declareBean(ApplicationContext.class, null, null, null);
        for (Scope scope : Scope.values()) {
            this.injector.addScope(scope);
        }
        for (ApplicationPlugin plugin : this.descriptor.getPlugins().values()) {
            Class<?> aClass = plugin.getClass();
            ApplicationPlugin o = plugin;
            this.injector.bindBean(aClass, null, o);
        }
        for (BeanDescriptor bean : this.descriptor.getBeans()) {
            bean.bind(this.injector);
        }
        Filter filter = new Filter<Class<?>>(){
            HashSet<String> blackList = new HashSet();

            @Override
            public boolean accept(Class<?> elt) {
                if (elt.getName().startsWith("juzu.")) {
                    return false;
                }
                if (elt.getPackage().getName().startsWith(ApplicationBootstrap.this.descriptor.getPackageName())) {
                    return true;
                }
                String currentPkg = elt.getPackage().getName();
                while (currentPkg != null) {
                    if (this.blackList.contains(currentPkg)) {
                        return false;
                    }
                    try {
                        Class<?> packageClass = ApplicationBootstrap.this.descriptor.getApplicationLoader().loadClass(currentPkg + ".package-info");
                        Application ann = packageClass.getAnnotation(Application.class);
                        if (ann != null) {
                            this.blackList.add(currentPkg);
                            return false;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    currentPkg = Tools.parentPackageOf(currentPkg);
                }
                return true;
            }
        };
        try {
            injectionContext = this.injector.create(filter);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("handle me gracefully", e);
        }
        BeanLifeCycle<ApplicationContext> contextLifeCycle = injectionContext.get(ApplicationContext.class);
        try {
            contextLifeCycle.get();
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("handle me gracefully", e);
        }
        this.contextLifeCycle = contextLifeCycle;
        this.injectionContext = injectionContext;
    }

    ApplicationContext getContext() {
        return this.contextLifeCycle.peek();
    }

    void stop() {
        if (this.contextLifeCycle != null) {
            this.contextLifeCycle.release();
        }
        if (this.injectionContext != null) {
            this.injectionContext.shutdown();
        }
    }
}

