/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import juzu.PropertyMap;
import juzu.impl.common.JSON;
import juzu.impl.common.Path;
import juzu.impl.metadata.Descriptor;
import juzu.impl.plugin.application.ApplicationContext;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.template.TemplateRenderContextImpl;
import juzu.impl.plugin.template.metadata.TemplatesDescriptor;
import juzu.impl.template.spi.TemplateStub;
import juzu.template.Template;
import juzu.template.TemplateRenderContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplatePlugin
extends ApplicationPlugin {
    private TemplatesDescriptor descriptor;
    private final ConcurrentHashMap<Path, TemplateStub> stubs = new ConcurrentHashMap();
    @Inject
    ApplicationContext application;

    public TemplatePlugin() {
        super("template");
    }

    @Override
    public Descriptor init(ClassLoader loader, JSON config) throws Exception {
        this.descriptor = new TemplatesDescriptor(loader, config);
        return this.descriptor;
    }

    public TemplateStub resolveTemplateStub(String path) {
        return this.resolveTemplateStub(Path.parse(path));
    }

    public TemplateStub resolveTemplateStub(Path path) {
        TemplateStub stub = this.stubs.get(path);
        if (stub == null) {
            try {
                StringBuilder id = new StringBuilder(this.descriptor.getPackageName());
                for (String name : path.getDirs()) {
                    if (id.length() > 0) {
                        id.append('.');
                    }
                    id.append(name);
                }
                id.append('.').append(path.getRawName());
                id.append("_");
                ClassLoader cl = this.application.getClassLoader();
                Class<?> stubClass = cl.loadClass(id.toString());
                stub = (TemplateStub)stubClass.newInstance();
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("handle me gracefully", e);
            }
            TemplateStub phantom = this.stubs.putIfAbsent(path, stub);
            if (phantom != null) {
                stub = phantom;
            } else {
                stub.init(this.application.getClassLoader());
            }
        }
        return stub;
    }

    public TemplateRenderContext render(Template template, PropertyMap properties, Map<String, ?> parameters, Locale locale) {
        TemplateStub stub = this.resolveTemplateStub(template.getPath());
        return new TemplateRenderContextImpl(this, properties, stub, parameters, locale);
    }
}

