/*
 * Copyright (C) 2012 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package juzu.asset;

/** @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a> */
public enum AssetLocation {

  /**
   * An external asset, not managed by Juzu.
   */
  URL,

  /**
   * A server served asset, server assets URI is managed by Juzu and is computed relative to the server
   * deployment. For instance, for a web application, the asset is located in the web application archive.
   */
  SERVER,

  /**
   * A classpath served asset.
   */
  CLASSPATH;

  public static AssetLocation safeValueOf(String name) {
    if (name != null) {
      try {
        return valueOf(name);
      }
      catch (IllegalArgumentException e) {
        // Should log as warning ?
      }
    }
    return null;
  }
}
