/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.url;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.inject.Inject;
import juzu.impl.common.Content;
import juzu.impl.common.Timestamped;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.PathType;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.url.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLFileSystem
extends ReadFileSystem<Node> {
    private final Node root = new Node();

    public URLFileSystem add(ClassLoader loader) throws IOException, URISyntaxException {
        return this.add(loader, loader.getParent());
    }

    public URLFileSystem add(ClassLoader from, ClassLoader to) throws IOException, URISyntaxException {
        URL url;
        URL url22;
        HashSet<URL> urls = Tools.set(from.getResources(""));
        Enumeration<URL> e = from.getResources("META-INF/MANIFEST.MF");
        while (e.hasMoreElements()) {
            url22 = e.nextElement();
            if (!"jar".equals(url22.getProtocol())) continue;
            urls.add(url22);
        }
        if (to != null) {
            e = to.getResources("");
            while (e.hasMoreElements()) {
                urls.remove(e.nextElement());
            }
            e = to.getResources("META-INF/MANIFEST.MF");
            while (e.hasMoreElements()) {
                url22 = e.nextElement();
                if (!"jar".equals(url22.getProtocol())) continue;
                urls.remove(url22);
            }
        }
        if (Inject.class.getClassLoader() == from && (url = from.getResource(Inject.class.getName().replace('.', '/') + ".class")) != null) {
            urls.add(url);
        }
        for (URL url22 : urls) {
            if (url22.getProtocol().equals("jar")) {
                String s = url22.toString();
                int pos = s.lastIndexOf("!/");
                this.add(new URL(s.substring(0, pos + 2)));
                continue;
            }
            this.add(url22);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URLFileSystem add(URL url) throws IOException, URISyntaxException {
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            File file = new File(url.toURI());
            if (file.isDirectory()) {
                this.root.merge(file);
                return this;
            } else {
                JarFile jar = new JarFile(file, false);
                for (JarEntry jarEntry : Tools.iterable(jar.entries())) {
                    this.root.merge("jar:" + url + "!/", jarEntry.getName());
                }
            }
            return this;
        } else {
            if (!"jar".equals(protocol)) throw new UnsupportedOperationException("Cannot handle url " + url + " yet");
            String path = url.getPath();
            int pos = path.lastIndexOf("!/");
            if (pos == -1) {
                throw new MalformedURLException("Malformed URL " + url);
            }
            URL inner = new URL(path.substring(0, pos));
            if (!inner.getProtocol().equals("file")) throw new UnsupportedOperationException("Not yet supported");
            File file = new File(inner.toURI());
            if (file.isDirectory()) {
                throw new IllegalArgumentException("Wrong jar URL " + url);
            }
            String prefix = path.substring(pos + 2);
            if (prefix.length() > 0 && !prefix.endsWith("/")) {
                throw new IllegalArgumentException("Wrong nested jar URL, should end with a / or be empty" + url);
            }
            JarFile jar = new JarFile(file, false);
            for (JarEntry jarEntry : Tools.iterable(jar.entries())) {
                String name = jarEntry.getName();
                if (!name.startsWith(prefix)) continue;
                this.root.merge("jar:" + inner + "!/" + prefix, name.substring(prefix.length()));
            }
        }
        return this;
    }

    @Override
    public Class<Node> getType() {
        return null;
    }

    @Override
    public String getDescription() {
        return "URLFileSystem[]";
    }

    @Override
    public boolean equals(Node left, Node right) {
        return left == right;
    }

    @Override
    public Node getRoot() throws IOException {
        return this.root;
    }

    @Override
    public Node getChild(Node dir, String name) throws IOException {
        return (Node)dir.get(name);
    }

    @Override
    public long getLastModified(Node path) throws IOException {
        return 1L;
    }

    @Override
    public String getName(Node path) {
        return (String)path.getKey();
    }

    @Override
    public Iterator<Node> getChildren(Node dir) throws IOException {
        return dir.getEntries();
    }

    @Override
    public PathType typeOf(Node path) throws IOException {
        return path.url == null ? PathType.DIR : PathType.FILE;
    }

    @Override
    public Timestamped<Content> getContent(Node file) throws IOException {
        if (file.url == null) {
            throw new IOException("Cannot find file " + file.getPath());
        }
        URLConnection conn = file.url.openConnection();
        long lastModified = conn.getLastModified();
        byte[] bytes = Tools.bytes(conn.getInputStream());
        return new Timestamped<Content>(lastModified, new Content(bytes, Charset.defaultCharset()));
    }

    @Override
    public File getFile(Node path) {
        return null;
    }

    @Override
    public URL getURL(Node path) throws NullPointerException, IOException {
        return path.url;
    }
}

