/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import juzu.EventQueue;
import juzu.Response;
import juzu.bridge.portlet.JuzuPortlet;
import juzu.impl.bridge.spi.portlet.PortletEventProducer;
import juzu.impl.bridge.spi.portlet.PortletRequestBridge;
import juzu.impl.plugin.application.Application;
import juzu.impl.request.ContextualArgument;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.Method;
import juzu.impl.request.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletInteractionBridge<Rq extends PortletRequest, Rs extends StateAwareResponse>
extends PortletRequestBridge<Rq, Rs> {
    protected PortletInteractionBridge(Application application, Rq req, Rs resp, PortletConfig config, boolean prod) {
        super(application, req, resp, config, prod);
        this.init();
    }

    protected PortletInteractionBridge(Application application, Rq req, Rs resp, PortletConfig config, Method<?> target, Map<String, String[]> parameters, boolean prod) {
        super(application, req, resp, config, target, parameters, prod);
        this.init();
    }

    private void init() {
        for (Parameter parameter : this.target.getParameters()) {
            ContextualParameter contextualParameter;
            if (!(parameter instanceof ContextualParameter) || !EventQueue.class.isAssignableFrom((contextualParameter = (ContextualParameter)parameter).getType())) continue;
            PortletEventProducer producer = new PortletEventProducer();
            this.arguments.put(contextualParameter.getName(), new ContextualArgument(contextualParameter, producer));
        }
    }

    @Override
    public void setResponse(Response response) throws IllegalStateException, IOException {
        super.setResponse(response);
        if (response instanceof Response.View) {
            WindowState windowState;
            Response.View update = (Response.View)response;
            for (Map.Entry<String, String[]> entry : update.getParameters().entrySet()) {
                ((StateAwareResponse)this.resp).setRenderParameter(entry.getKey(), entry.getValue());
            }
            Method method = this.application.getDescriptor().getControllers().getMethodByHandle(update.getTarget());
            ((StateAwareResponse)this.resp).setRenderParameter("juzu.op", method.getId());
            PortletMode portletMode = update.getProperties().getValue(JuzuPortlet.PORTLET_MODE);
            if (portletMode != null) {
                try {
                    ((StateAwareResponse)this.resp).setPortletMode(portletMode);
                }
                catch (PortletModeException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if ((windowState = update.getProperties().getValue(JuzuPortlet.WINDOW_STATE)) != null) {
                try {
                    ((StateAwareResponse)this.resp).setWindowState(windowState);
                }
                catch (WindowStateException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
    }
}

