/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.cdi;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Provider;
import juzu.Scope;
import juzu.impl.common.Filter;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.inject.ScopeController;
import juzu.impl.inject.spi.InjectionContext;
import juzu.impl.inject.spi.Injector;
import juzu.impl.inject.spi.cdi.AbstractBean;
import juzu.impl.inject.spi.cdi.CDIContext;
import juzu.impl.inject.spi.cdi.DeclaredBean;
import juzu.impl.inject.spi.cdi.DeclaredProviderBean;
import juzu.impl.inject.spi.cdi.SingletonBean;
import juzu.impl.inject.spi.cdi.SingletonProviderBean;
import juzu.impl.inject.spi.cdi.weld.WeldContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDIBuilder
extends Injector {
    private Set<Scope> scopes = new HashSet<Scope>();
    private ClassLoader classLoader;
    private List<ReadFileSystem<?>> fileSystems = new ArrayList();
    private ArrayList<AbstractBean> boundBeans = new ArrayList();

    @Override
    public <T> Injector declareBean(Class<T> type, Scope beanScope, Iterable<Annotation> qualifiers, Class<? extends T> implementationType) {
        this.boundBeans.add(new DeclaredBean(implementationType != null ? implementationType : type, beanScope, qualifiers));
        return this;
    }

    @Override
    public <T> Injector declareProvider(Class<T> type, Scope beanScope, Iterable<Annotation> qualifiers, Class<? extends Provider<T>> provider) {
        this.boundBeans.add(new DeclaredProviderBean(type, beanScope, qualifiers, provider));
        return this;
    }

    @Override
    public <P> Injector addFileSystem(ReadFileSystem<P> fs) {
        this.fileSystems.add(fs);
        return this;
    }

    @Override
    public Injector addScope(Scope scope) {
        this.scopes.add(scope);
        return this;
    }

    @Override
    public Injector setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Override
    public <T> Injector bindBean(Class<T> type, Iterable<Annotation> qualifiers, T instance) {
        this.boundBeans.add(new SingletonBean(type, qualifiers, instance));
        return this;
    }

    @Override
    public <T> Injector bindProvider(Class<T> beanType, Scope beanScope, Iterable<Annotation> beanQualifiers, Provider<? extends T> provider) {
        this.boundBeans.add(new SingletonProviderBean(beanType, beanScope, beanQualifiers, provider));
        return this;
    }

    @Override
    public InjectionContext<?, ?> create(Filter<Class<?>> filter) throws Exception {
        WeldContainer container = new WeldContainer(this.classLoader, ScopeController.INSTANCE, this.scopes);
        for (ReadFileSystem<?> fs : this.fileSystems) {
            container.addFileSystem(fs);
        }
        return new CDIContext(container, filter, this.boundBeans);
    }
}

