/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.util.List;
import juzu.impl.common.PercentCodec;
import juzu.impl.router.PathParam;
import juzu.impl.router.RERef;
import juzu.impl.router.Route;
import juzu.impl.router.Router;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PatternRoute
extends Route {
    final RERef pattern;
    final PathParam[] params;
    final String[] chunks;
    final String[] encodedChunks;

    PatternRoute(Router router, RERef pattern, List<PathParam> params, List<String> chunks, int terminal) {
        super(router, terminal);
        if (chunks.size() != params.size() + 1) {
            throw new AssertionError((Object)("Was expecting chunk size " + chunks.size() + " to be equals to " + (params.size() + 1)));
        }
        String[] encodedChunks = new String[chunks.size()];
        for (int i = 0; i < chunks.size(); ++i) {
            encodedChunks[i] = PercentCodec.PATH_SEGMENT.encode(chunks.get(i));
        }
        this.pattern = pattern;
        this.params = params.toArray(new PathParam[params.size()]);
        this.chunks = chunks.toArray(new String[chunks.size()]);
        this.encodedChunks = encodedChunks;
    }
}

