/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller;

import juzu.impl.common.JSON;
import juzu.impl.metadata.Descriptor;
import juzu.impl.plugin.application.ApplicationException;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.controller.ControllerResolver;
import juzu.impl.plugin.controller.descriptor.ControllersDescriptor;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.Method;
import juzu.impl.request.Parameter;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.request.ActionContext;
import juzu.request.ApplicationContext;
import juzu.request.ClientContext;
import juzu.request.HttpContext;
import juzu.request.RequestContext;
import juzu.request.ResourceContext;
import juzu.request.SecurityContext;
import juzu.request.UserContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerPlugin
extends ApplicationPlugin
implements RequestFilter {
    private ControllersDescriptor descriptor;

    public ControllerPlugin() {
        super("controller");
    }

    public ControllersDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ControllerResolver<Method> getResolver() {
        return this.descriptor != null ? this.descriptor.getResolver() : null;
    }

    @Override
    public Descriptor init(ClassLoader loader, JSON config) throws Exception {
        this.descriptor = new ControllersDescriptor(loader, config);
        return this.descriptor;
    }

    @Override
    public void invoke(Request request) throws ApplicationException {
        RequestContext context = request.getContext();
        Method method = context.getMethod();
        for (Parameter parameter : method.getParameters()) {
            if (!(parameter instanceof ContextualParameter)) continue;
            ContextualParameter contextualParameter = (ContextualParameter)parameter;
            this.tryInject(request, contextualParameter, RequestContext.class, context);
            this.tryInject(request, contextualParameter, HttpContext.class, context.getHttpContext());
            this.tryInject(request, contextualParameter, SecurityContext.class, context.getSecurityContext());
            this.tryInject(request, contextualParameter, ApplicationContext.class, context.getApplicationContext());
            this.tryInject(request, contextualParameter, UserContext.class, context.getUserContext());
            if (context instanceof ResourceContext) {
                ResourceContext resourceContext = (ResourceContext)context;
                this.tryInject(request, contextualParameter, ClientContext.class, resourceContext.getClientContext());
                continue;
            }
            if (!(context instanceof ActionContext)) continue;
            ActionContext actionContext = (ActionContext)context;
            this.tryInject(request, contextualParameter, ClientContext.class, actionContext.getClientContext());
        }
        request.invoke();
    }

    private <T> void tryInject(Request request, ContextualParameter parameter, Class<T> type, T instance) {
        if (instance != null && type.isAssignableFrom(parameter.getType())) {
            request.setArgument(parameter, instance);
        }
    }
}

