/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller.descriptor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import juzu.impl.common.JSON;
import juzu.impl.common.MethodHandle;
import juzu.impl.inject.BeanDescriptor;
import juzu.impl.metadata.Descriptor;
import juzu.impl.plugin.controller.ControllerResolver;
import juzu.impl.plugin.controller.descriptor.ControllerDescriptor;
import juzu.impl.plugin.controller.descriptor.ControllerDescriptorResolver;
import juzu.impl.request.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllersDescriptor
extends Descriptor {
    private final Class<?> defaultController;
    private final List<ControllerDescriptor> controllers;
    private final ArrayList<Method> methods;
    private final ArrayList<BeanDescriptor> beans;
    private final Boolean escapeXML;
    private ControllerDescriptorResolver resolver;
    private final Map<MethodHandle, Method> byHandle;

    public ControllersDescriptor(ClassLoader loader, JSON config) throws Exception {
        ArrayList<ControllerDescriptor> controllers = new ArrayList<ControllerDescriptor>();
        ArrayList controllerMethods = new ArrayList();
        ArrayList<BeanDescriptor> beans = new ArrayList<BeanDescriptor>();
        HashMap<MethodHandle, Method> byHandle = new HashMap<MethodHandle, Method>();
        for (String fqn : config.getList("controllers", String.class)) {
            Class<?> clazz = loader.loadClass(fqn);
            Field f = clazz.getField("DESCRIPTOR");
            ControllerDescriptor bean = (ControllerDescriptor)f.get(null);
            for (Method<?> method : bean.getMethods()) {
                byHandle.put(method.getHandle(), method);
            }
            controllers.add(bean);
            controllerMethods.addAll(bean.getMethods());
            beans.add(BeanDescriptor.createFromBean(bean.getType(), null, null));
        }
        Boolean escapeXML = config.getBoolean("escapeXML");
        Class<?> defaultController = null;
        String defaultControllerName = config.getString("default");
        if (defaultControllerName != null) {
            defaultController = loader.loadClass(defaultControllerName);
        }
        this.escapeXML = escapeXML;
        this.defaultController = defaultController;
        this.controllers = controllers;
        this.methods = controllerMethods;
        this.beans = beans;
        this.resolver = new ControllerDescriptorResolver(this);
        this.byHandle = byHandle;
    }

    @Override
    public Iterable<BeanDescriptor> getBeans() {
        return this.beans;
    }

    public ControllerResolver<Method> getResolver() {
        return this.resolver;
    }

    public Class<?> getDefault() {
        return this.defaultController;
    }

    public Boolean getEscapeXML() {
        return this.escapeXML;
    }

    public List<ControllerDescriptor> getControllers() {
        return this.controllers;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public Method getMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        for (int i = 0; i < this.methods.size(); ++i) {
            Class<?>[] a;
            Method cm = this.methods.get(i);
            java.lang.reflect.Method m = cm.getMethod();
            if (!type.equals(cm.getType()) || !m.getName().equals(name) || (a = m.getParameterTypes()).length != parameterTypes.length) continue;
            for (int j = 0; j < parameterTypes.length; ++j) {
                if (a[j].equals(parameterTypes[j])) continue;
            }
            return cm;
        }
        return null;
    }

    public Method getMethodById(String methodId) {
        for (int i = 0; i < this.methods.size(); ++i) {
            Method cm = this.methods.get(i);
            if (!cm.getId().equals(methodId)) continue;
            return cm;
        }
        return null;
    }

    public Method getMethodByHandle(MethodHandle handle) {
        return this.byHandle.get(handle);
    }
}

