/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.servlet;

import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.lang.model.element.PackageElement;
import javax.tools.JavaFileObject;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.plugin.servlet.Servlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletMetaModelPlugin
extends ApplicationMetaModelPlugin {
    public static final MessageCode CANNOT_WRITE_SERVLET_CLASS = new MessageCode("CANNOT_WRITE_SERVLET_CLASS", "The servlet class %1$s cannot be written");
    private static final Name SERVLET = Name.create(Servlet.class);
    private final HashMap<ElementHandle.Package, AnnotationState> servlets = new HashMap();

    public ServletMetaModelPlugin() {
        super("servlet");
    }

    @Override
    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Collections.singleton(Servlet.class);
    }

    @Override
    public void processAnnotationAdded(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        ElementHandle.Package pkg = metaModel.getHandle();
        if (key.getType().equals(SERVLET) && key.getElement().getPackage().equals(pkg.getPackage())) {
            this.servlets.put(pkg, added);
        }
    }

    @Override
    public void processAnnotationRemoved(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState removed) {
        ElementHandle.Package pkg = metaModel.getHandle();
        if (key.getType().equals(SERVLET) && key.getElement().getPackage().equals(pkg.getPackage())) {
            this.servlets.remove(pkg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void postProcessAnnotations(ApplicationMetaModel metaModel) {
        ElementHandle.Package pkg = metaModel.getHandle();
        AnnotationState annotation = this.servlets.remove(pkg);
        if (annotation == null) return;
        PackageElement pkgElt = metaModel.processingContext.get(pkg);
        String urlPattern = (String)annotation.get("value");
        String simpleName = (String)annotation.get("name");
        if (simpleName == null) {
            simpleName = metaModel.getBaseName() + "Servlet";
        }
        Name clazz = pkg.getPackage().append(simpleName);
        Writer writer = null;
        try {
            try {
                JavaFileObject file = metaModel.processingContext.createSourceFile(clazz, pkgElt);
                writer = file.openWriter();
                writer.append("package ").append(pkg.getPackage()).append(";\n");
                writer.append("import javax.servlet.annotation.WebServlet;\n");
                writer.append("import javax.servlet.annotation.WebInitParam;\n");
                writer.append("@WebServlet(name=\"").append(simpleName).append("\",urlPatterns=\"").append(urlPattern).append("\")\n");
                writer.append("public class ").append(simpleName).append(" extends juzu.bridge.servlet.JuzuServlet {\n");
                writer.append("@Override\n");
                writer.append("protected String getApplicationName(javax.servlet.ServletConfig config) {\n");
                writer.append("return \"").append(pkg.getPackage()).append("\";\n");
                writer.append("}\n");
                writer.append("}\n");
            }
            catch (IOException e) {
                throw CANNOT_WRITE_SERVLET_CLASS.failure(e, pkgElt, pkg.getPackage());
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            Tools.safeClose(writer);
            throw throwable;
        }
        Tools.safeClose(writer);
    }
}

