/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge;

import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import juzu.Response;
import juzu.impl.asset.AssetServer;
import juzu.impl.bridge.BridgeConfig;
import juzu.impl.bridge.spi.ActionBridge;
import juzu.impl.bridge.spi.EventBridge;
import juzu.impl.bridge.spi.RenderBridge;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.bridge.spi.ResourceBridge;
import juzu.impl.common.Formatting;
import juzu.impl.common.Logger;
import juzu.impl.common.Tools;
import juzu.impl.compiler.CompilationError;
import juzu.impl.compiler.CompilationException;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.plugin.application.ApplicationLifeCycle;
import juzu.impl.plugin.module.ModuleLifeCycle;
import juzu.impl.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bridge
implements Closeable {
    private final Logger log;
    private final AssetServer server;
    private final BridgeConfig config;
    private final ReadFileSystem<?> resources;
    private final ResourceResolver resolver;
    private final ModuleLifeCycle module;
    public ClassLoader classLoader;
    public ApplicationLifeCycle application;

    public Bridge(Logger log, ModuleLifeCycle module, BridgeConfig config, ReadFileSystem<?> resources, AssetServer server, ResourceResolver resolver) {
        this.log = log;
        this.module = module;
        this.config = config;
        this.resources = resources;
        this.server = server;
        this.resolver = resolver;
    }

    public BridgeConfig getConfig() {
        return this.config;
    }

    public void refresh() throws Exception {
        if (this.application == null) {
            this.application = new ApplicationLifeCycle(this.log, this.module, this.config.injectImpl, this.config.name, this.resources, this.server, this.resolver);
        }
        this.application.refresh();
    }

    public void invoke(RequestBridge requestBridge) throws Throwable {
        if (requestBridge instanceof ActionBridge) {
            this.processAction((ActionBridge)requestBridge);
        } else if (requestBridge instanceof RenderBridge) {
            this.render((RenderBridge)requestBridge);
        } else if (requestBridge instanceof ResourceBridge) {
            this.serveResource((ResourceBridge)requestBridge);
        } else {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(ActionBridge requestBridge) throws Throwable {
        try {
            this.application.getApplication().invoke(requestBridge);
        }
        finally {
            requestBridge.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(EventBridge requestBridge) throws Throwable {
        try {
            this.application.getApplication().invoke(requestBridge);
        }
        finally {
            requestBridge.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(RenderBridge requestBridge) throws Throwable {
        List<CompilationError> errors = null;
        try {
            this.refresh();
        }
        catch (CompilationException e) {
            errors = e.getErrors();
        }
        if (errors == null || errors.isEmpty()) {
            if (errors != null) {
                requestBridge.purgeSession();
            }
            try {
                this.application.getApplication().invoke(requestBridge);
            }
            finally {
                requestBridge.close();
            }
        }
        try {
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            Formatting.renderErrors(printer, errors);
            requestBridge.setResponse(Response.ok(writer.getBuffer()));
        }
        finally {
            requestBridge.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveResource(ResourceBridge requestBridge) throws Throwable {
        try {
            this.application.getApplication().invoke(requestBridge);
        }
        finally {
            requestBridge.close();
        }
    }

    private void logThrowable(Throwable t) {
        this.log.log(t.getMessage(), t);
    }

    @Override
    public void close() {
        Tools.safeClose(this.application);
    }
}

