/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.servlet;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.BridgeConfig;
import juzu.impl.bridge.spi.servlet.ServletModule;
import juzu.impl.bridge.spi.servlet.ServletWebBridge;
import juzu.impl.bridge.spi.web.Handler;
import juzu.impl.common.Logger;
import juzu.impl.common.SimpleMap;
import juzu.impl.common.Tools;
import juzu.impl.plugin.application.descriptor.ApplicationModuleDescriptor;
import juzu.impl.resource.ResourceResolver;

public class ServletBridge
extends HttpServlet {
    ServletModule module;
    Logger log;
    private BridgeConfig config;
    private Handler handler;
    private String path;

    public void init() throws ServletException {
        BridgeConfig config;
        final ServletConfig servletConfig = this.getServletConfig();
        Logger log = new Logger(){

            public void log(CharSequence msg) {
                System.out.println("[" + servletConfig.getServletName() + "] " + msg);
            }

            public void log(CharSequence msg, Throwable t) {
                System.err.println("[" + servletConfig.getServletName() + "] " + msg);
                t.printStackTrace();
            }
        };
        try {
            config = new BridgeConfig((Map<String, String>)new SimpleMap<String, String>(){

                @Override
                protected Iterator<String> keys() {
                    return BridgeConfig.NAMES.iterator();
                }

                @Override
                public String get(Object key) {
                    if ("juzu.app_name".equals(key)) {
                        return ServletBridge.this.getApplicationName(servletConfig);
                    }
                    if ("juzu.inject".equals(key)) {
                        String inject = servletConfig.getInitParameter((String)key);
                        if (inject == null) {
                            inject = servletConfig.getServletContext().getInitParameter((String)key);
                        }
                        return inject;
                    }
                    if (BridgeConfig.NAMES.contains(key)) {
                        return servletConfig.getInitParameter((String)key);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw ServletBridge.wrap(e);
        }
        if (config.name == null) {
            throw new ServletException("No application configured");
        }
        this.module = null;
        this.log = log;
        this.config = config;
        this.handler = null;
        this.path = null;
    }

    static ServletException wrap(Throwable e) {
        return e instanceof ServletException ? (ServletException)e : new ServletException("Could not find an application to start", e);
    }

    protected String getApplicationName(ServletConfig config) {
        return config.getInitParameter("juzu.app_name");
    }

    private void refresh() throws ServletException {
        if (this.module == null) {
            try {
                this.module = ServletModule.leaseModule(this.getServletContext(), Thread.currentThread().getContextClassLoader());
            }
            catch (Exception e) {
                throw ServletBridge.wrap(e);
            }
        }
        try {
            boolean stale = this.module.lifeCycle.refresh();
            if (stale && this.handler != null) {
                Tools.safeClose(this.handler);
                this.handler = null;
            }
        }
        catch (Exception e) {
            throw ServletBridge.wrap(e);
        }
        if (this.handler == null) {
            ApplicationModuleDescriptor desc = (ApplicationModuleDescriptor)this.module.getDescriptors().get("application");
            Bridge bridge = new Bridge(this.log, this.module.lifeCycle, this.config, this.module.resources, this.module.server, new ResourceResolver(){

                public URL resolve(String uri) {
                    try {
                        return ServletBridge.this.getServletConfig().getServletContext().getResource(uri);
                    }
                    catch (MalformedURLException e) {
                        return null;
                    }
                }
            });
            String path = null;
            ServletRegistration reg = this.getServletContext().getServletRegistration(this.getServletName());
            for (String mapping : reg.getMappings()) {
                if ("/".equals(mapping)) {
                    path = "";
                    break;
                }
                if ("/*".equals(mapping)) {
                    throw new UnsupportedOperationException("Implement me");
                }
                if (mapping.endsWith("/*")) {
                    path = mapping.substring(0, mapping.length() - 2);
                    continue;
                }
                throw new UnsupportedOperationException("Should not be possible");
            }
            if (path == null) {
                throw new ServletException("Juzu servlet should be mounted on an url pattern");
            }
            Handler handler = null;
            try {
                handler = new Handler(bridge);
            }
            catch (Exception e) {
                throw ServletBridge.wrap(e);
            }
            this.handler = handler;
            this.path = path;
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getMethod().equals("GET") || req.getMethod().equals("POST")) {
            URL url;
            this.refresh();
            ServletWebBridge bridge = new ServletWebBridge(req, resp, this.path);
            if (bridge.getRequestPath().length() > 1 && !bridge.getRequestPath().startsWith("/WEB-INF/") && (url = this.getServletContext().getResource(bridge.getRequestPath())) != null) {
                RequestDispatcher dispatcher = this.getServletContext().getNamedDispatcher("default");
                dispatcher.include((ServletRequest)bridge.getRequest(), (ServletResponse)bridge.getResponse());
                return;
            }
            try {
                this.handler.handle(bridge);
            }
            catch (Throwable throwable) {
                throw ServletBridge.wrap(throwable);
            }
        } else {
            super.service(req, resp);
        }
    }

    public void destroy() {
        if (this.module != null) {
            this.module.release();
        }
        if (this.handler != null) {
            Tools.safeClose(this.handler);
            this.handler = null;
        }
    }
}

