/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.asset.Asset;
import juzu.impl.bridge.spi.RenderBridge;
import juzu.impl.bridge.spi.web.Handler;
import juzu.impl.bridge.spi.web.WebBridge;
import juzu.impl.bridge.spi.web.WebMimeBridge;
import juzu.impl.common.Tools;
import juzu.impl.inject.ScopedContext;
import juzu.impl.plugin.application.Application;
import juzu.impl.request.Method;
import juzu.io.AppendableStream;
import juzu.io.Stream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebRenderBridge
extends WebMimeBridge
implements RenderBridge {
    WebRenderBridge(Application application, Handler handler, WebBridge http, Method<?> target, Map<String, String[]> parameters) {
        super(application, handler, http, target, parameters);
    }

    @Override
    public void end() {
        super.end();
        ScopedContext context = this.http.getFlashScope(false);
        if (context != null) {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean send() throws IOException {
        if (super.send()) {
            return true;
        }
        if (this.response instanceof Response.Content) {
            Iterable<Map.Entry<String, String[]>> headers;
            Response.Content content = (Response.Content)this.response;
            PropertyMap properties = this.response.getProperties();
            this.http.setContentType(content.getMimeType());
            Integer status = content.getStatus();
            if (status != null) {
                this.http.setStatus(status);
            }
            if ((headers = properties.getValues(PropertyType.HEADER)) != null) {
                for (Map.Entry<String, String[]> entry : headers) {
                    this.http.setHeader(entry.getKey(), entry.getValue()[0]);
                }
            }
            Writer writer = null;
            try {
                Iterable<Asset> scriptsProp;
                Iterable<Asset> stylesheetProps;
                Iterable<Map.Entry<String, String>> metaProps;
                writer = this.http.getWriter();
                writer.append("<!DOCTYPE html>\n");
                writer.append("<html>\n");
                writer.append("<head>\n");
                String title = properties.getValue(PropertyType.TITLE);
                if (title != null) {
                    writer.append("<title>");
                    writer.append(title);
                    writer.append("</title>\n");
                }
                if ((metaProps = properties.getValues(PropertyType.META_TAG)) != null) {
                    for (Map.Entry<String, String> meta : metaProps) {
                        writer.append("<meta name=\"");
                        writer.append(meta.getKey());
                        writer.append("\" content=\"");
                        writer.append(meta.getValue());
                        writer.append("\">\n");
                    }
                }
                if ((stylesheetProps = properties.getValues(PropertyType.STYLESHEET)) != null) {
                    Iterable<Asset.Value> stylesheets = this.handler.getBridge().application.getStylesheetManager().resolveAssets(stylesheetProps);
                    for (Asset.Value stylesheet : stylesheets) {
                        String path = stylesheet.getURI();
                        int pos = path.lastIndexOf(46);
                        String ext = pos == -1 ? "css" : path.substring(pos + 1);
                        writer.append("<link rel=\"stylesheet\" type=\"text/");
                        writer.append(ext);
                        writer.append("\" href=\"");
                        writer.append(this.getAssetURL(stylesheet));
                        writer.append("\"></link>\n");
                    }
                }
                if ((scriptsProp = properties.getValues(PropertyType.SCRIPT)) != null) {
                    Iterable<Asset.Value> scripts = this.handler.getBridge().application.getScriptManager().resolveAssets(scriptsProp);
                    for (Asset.Value script : scripts) {
                        writer.append("<script type=\"text/javascript\" src=\"");
                        writer.append(this.getAssetURL(script));
                        writer.append("\"></script>\n");
                    }
                }
                writer.append("</head>\n");
                writer.append("<body>\n");
                if (content.getKind() != Stream.Char.class) {
                    throw new UnsupportedOperationException("Not yet handled");
                }
                content.send(new AppendableStream(writer));
                writer.append("</body>\n");
                writer.append("</html>\n");
                Object var16_15 = null;
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                Tools.safeClose(writer);
                throw throwable;
            }
            Tools.safeClose(writer);
            return true;
        }
        return false;
    }

    private String getAssetURL(Asset.Value asset) throws IOException {
        StringBuilder url = new StringBuilder();
        String uri = asset.getURI();
        this.http.renderAssetURL(asset.getLocation(), uri, url);
        return url.toString();
    }
}

