/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge;

import java.io.Closeable;
import juzu.impl.asset.AssetServer;
import juzu.impl.bridge.BridgeConfig;
import juzu.impl.common.Logger;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.plugin.application.Application;
import juzu.impl.plugin.application.ApplicationLifeCycle;
import juzu.impl.plugin.module.Module;
import juzu.impl.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bridge
implements Closeable {
    private final Logger log;
    private final AssetServer server;
    private final BridgeConfig config;
    private final ReadFileSystem<?> resources;
    private final ResourceResolver resolver;
    public final Module module;
    public ApplicationLifeCycle<?, ?> application;

    public Bridge(Logger log, Module module, BridgeConfig config, ReadFileSystem<?> resources, AssetServer server, ResourceResolver resolver) {
        this.log = log;
        this.module = module;
        this.config = config;
        this.resources = resources;
        this.server = server;
        this.resolver = resolver;
    }

    public BridgeConfig getConfig() {
        return this.config;
    }

    public boolean refresh() throws Exception {
        this.module.context.getLifeCycle().refresh();
        if (this.application == null) {
            this.application = new ApplicationLifeCycle(this.log, this.module.context.getLifeCycle(), this.config.injectImpl, this.config.name, this.resources, this.server, this.resolver);
        }
        return this.application.refresh();
    }

    public Application getApplication() {
        return this.application.getApplication();
    }

    @Override
    public void close() {
        Tools.safeClose(this.application);
    }
}

