/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceURL;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.impl.asset.Asset;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.RenderBridge;
import juzu.impl.bridge.spi.portlet.PortletMimeBridge;
import juzu.impl.common.Formatting;
import juzu.impl.compiler.CompilationException;
import juzu.impl.inject.ScopedContext;
import juzu.request.Phase;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRenderBridge
extends PortletMimeBridge<RenderRequest, RenderResponse>
implements RenderBridge {
    public PortletRenderBridge(Bridge bridge, RenderRequest request, RenderResponse response, PortletConfig config) {
        super(bridge, request, response, config);
    }

    @Override
    protected Phase getPhase() {
        return Phase.VIEW;
    }

    @Override
    public void invoke() throws Exception {
        try {
            this.bridge.refresh();
        }
        catch (CompilationException e) {
            StringWriter buffer = new StringWriter();
            PrintWriter printer = new PrintWriter(buffer);
            Formatting.renderErrors(printer, e.getErrors());
            this.setResponse(Response.error(buffer.toString()));
            this.purgeSession();
            return;
        }
        super.invoke();
    }

    @Override
    protected void sendProperties() throws IOException {
        if (this.response instanceof Response.Content) {
            Response.Content content = (Response.Content)this.response;
            super.sendProperties();
            PropertyMap properties = content.getProperties();
            String title = properties.getValue(PropertyType.TITLE);
            if (title != null) {
                ((RenderResponse)this.resp).setTitle(title);
            }
            Iterable<String> scriptsProp = properties.getValues(PropertyType.SCRIPT);
            Iterable<String> stylesheetsProp = properties.getValues(PropertyType.STYLESHEET);
            Iterable<Map.Entry<String, String>> metas = properties.getValues(PropertyType.META_TAG);
            if (metas != null) {
                for (Map.Entry<String, String> entry : metas) {
                    Element elt = ((RenderResponse)this.resp).createElement("meta");
                    elt.setAttribute("name", entry.getKey());
                    elt.setAttribute("content", entry.getValue());
                    ((RenderResponse)this.resp).addProperty("javax.portlet.markup.head.element", elt);
                }
            }
            if (stylesheetsProp != null) {
                Iterable<Asset> stylesheets = this.bridge.application.getStylesheetManager().resolveAssets(stylesheetsProp);
                for (Asset stylesheet : stylesheets) {
                    int pos = stylesheet.getURI().lastIndexOf(46);
                    String ext = pos == -1 ? "css" : stylesheet.getURI().substring(pos + 1);
                    Element elt = ((RenderResponse)this.resp).createElement("link");
                    elt.setAttribute("media", "screen");
                    elt.setAttribute("rel", "stylesheet");
                    elt.setAttribute("type", "text/" + ext);
                    elt.setAttribute("href", this.getAssetURL(stylesheet));
                    ((RenderResponse)this.resp).addProperty("javax.portlet.markup.head.element", elt);
                }
            }
            if (scriptsProp != null) {
                Iterable<Asset> scripts = this.bridge.application.getScriptManager().resolveAssets(scriptsProp);
                for (Asset script : scripts) {
                    String url = this.getAssetURL(script);
                    Element elt = ((RenderResponse)this.resp).createElement("script");
                    elt.setAttribute("type", "text/javascript");
                    elt.setAttribute("src", url);
                    String data = this.bridge.application.getName() + " script ";
                    Comment comment = elt.getOwnerDocument().createComment(data);
                    elt.appendChild(comment);
                    ((RenderResponse)this.resp).addProperty("javax.portlet.markup.head.element", elt);
                }
            }
        }
    }

    private String getAssetURL(Asset asset) {
        String url;
        String uri = asset.getURI();
        switch (asset.getLocation()) {
            case SERVER: {
                StringBuilder sb = new StringBuilder();
                if (!uri.startsWith("/")) {
                    sb.append(((RenderRequest)this.req).getContextPath());
                    sb.append('/');
                }
                sb.append(uri);
                url = sb.toString();
                break;
            }
            case APPLICATION: {
                if (this.bridge.module.context.getRunMode().isStatic()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(((RenderRequest)this.req).getContextPath()).append("/assets");
                    if (!uri.startsWith("/")) {
                        sb.append('/');
                    }
                    sb.append(uri);
                    url = sb.toString();
                    break;
                }
                ResourceURL r = ((RenderResponse)this.resp).createResourceURL();
                r.setParameter("juzu.request", "assets");
                r.setResourceID(uri);
                url = r.toString();
                break;
            }
            case URL: {
                url = uri;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return url;
    }

    @Override
    public void end() {
        super.end();
        ScopedContext context = this.getFlashContext(false);
        if (context != null) {
            context.close();
        }
    }
}

