/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.io.IOException;
import java.util.Map;
import juzu.Response;
import juzu.impl.bridge.spi.ActionBridge;
import juzu.impl.bridge.spi.DispatchSPI;
import juzu.impl.bridge.spi.web.Handler;
import juzu.impl.bridge.spi.web.WebBridge;
import juzu.impl.bridge.spi.web.WebRequestBridge;
import juzu.impl.common.MimeType;
import juzu.impl.plugin.application.Application;
import juzu.impl.request.Method;
import juzu.request.ClientContext;
import juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebActionBridge
extends WebRequestBridge
implements ActionBridge {
    Response response;

    WebActionBridge(Application application, Handler handler, WebBridge http, Method<?> target, Map<String, String[]> parameters) {
        super(application, handler, http, target, parameters);
    }

    @Override
    public ClientContext getClientContext() {
        return this.http.getClientContext();
    }

    @Override
    public void setResponse(Response response) throws IllegalStateException, IOException {
        super.setResponse(response);
        if (!(response instanceof Response.View) && !(response instanceof Response.Redirect)) {
            throw new IllegalArgumentException("Cannot accept response " + response);
        }
        this.response = response;
    }

    @Override
    void send() throws IOException {
        if (this.response instanceof Response.View) {
            Response.View update = (Response.View)this.response;
            DispatchSPI spi = this.createDispatch(Phase.VIEW, update.getTarget(), update.getParameters());
            Phase.View.Dispatch dispatch = new Phase.View.Dispatch(spi);
            String url = ((Object)dispatch.with(MimeType.PLAIN).with(update.getProperties())).toString();
            for (Map.Entry entry : this.responseHeaders.entrySet()) {
                this.http.setHeader((String)entry.getKey(), ((String[])entry.getValue())[0]);
            }
            this.http.sendRedirect(url);
        } else if (this.response instanceof Response.Redirect) {
            Response.Redirect redirect = (Response.Redirect)this.response;
            String url = redirect.getLocation();
            this.http.sendRedirect(url);
        }
    }
}

