/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template.metamodel;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.tools.FileObject;
import juzu.impl.common.Content;
import juzu.impl.common.MethodInvocation;
import juzu.impl.common.Path;
import juzu.impl.common.Timestamped;
import juzu.impl.common.Tools;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.plugin.controller.metamodel.ControllerMetaModel;
import juzu.impl.plugin.controller.metamodel.ControllersMetaModel;
import juzu.impl.plugin.controller.metamodel.MethodMetaModel;
import juzu.impl.plugin.controller.metamodel.ParameterMetaModel;
import juzu.impl.plugin.template.metamodel.TemplateMetaModel;
import juzu.impl.plugin.template.metamodel.TemplatesMetaModel;
import juzu.impl.template.spi.ProcessContext;
import juzu.impl.template.spi.Template;
import juzu.impl.template.spi.TemplateProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModelTemplateProcessContext
extends ProcessContext {
    private TemplateMetaModel templateMetaModel;
    private final ProcessingContext env;

    ModelTemplateProcessContext(TemplateMetaModel templateMetaModel, Map<Path, Template<?>> templates, ProcessingContext env) {
        super(templates);
        this.templateMetaModel = templateMetaModel;
        this.env = env;
    }

    Collection<Template<?>> resolve(final TemplateMetaModel metaModel) {
        ElementHandle.Field handle = this.templateMetaModel.getRefs().iterator().next().getHandle();
        return (Collection)this.env.executeWithin(handle, new Callable<Collection<Template<?>>>(){

            @Override
            public Collection<Template<?>> call() throws Exception {
                HashSet keys = new HashSet(ModelTemplateProcessContext.this.templates.keySet());
                ModelTemplateProcessContext.this.resolveTemplate(metaModel.getPath());
                HashMap copy = new HashMap(ModelTemplateProcessContext.this.templates);
                copy.keySet().removeAll(keys);
                return copy.values();
            }
        });
    }

    @Override
    protected TemplateProvider resolverProvider(String ext) {
        return this.templateMetaModel.getTemplates().plugin.providers.get(ext);
    }

    @Override
    public MethodInvocation resolveMethodInvocation(String typeName, String methodName, Map<String, String> parameterMap) throws ProcessingException {
        MethodMetaModel method = this.templateMetaModel.getTemplates().getApplication().getChild(ControllersMetaModel.KEY).resolve(typeName, methodName, parameterMap.keySet());
        if (method == null) {
            throw ControllerMetaModel.CONTROLLER_METHOD_NOT_RESOLVED.failure(methodName + "(" + parameterMap + ")");
        }
        ArrayList<String> args = new ArrayList<String>();
        for (ParameterMetaModel param : method.getParameters()) {
            String value = parameterMap.get(param.getName());
            args.add(value);
        }
        return new MethodInvocation(method.getController().getHandle().getFQN() + "_", method.getName(), args);
    }

    @Override
    protected Timestamped<Content> resolveResource(Path path) {
        TemplatesMetaModel tmm = this.templateMetaModel.getTemplates();
        ElementHandle.Package context = tmm.getApplication().getHandle();
        FileObject resource = this.env.resolveResource(context, tmm.resolve(path));
        if (resource != null) {
            try {
                byte[] bytes = Tools.bytes(resource.openInputStream());
                long lastModified = resource.getLastModified();
                return new Timestamped<Content>(lastModified, new Content(bytes, Charset.defaultCharset()));
            }
            catch (Exception e) {
                this.env.log("Could not get resource content " + path.getCanonical(), e);
            }
        }
        return null;
    }
}

