/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.spi;

import java.io.Serializable;
import java.util.Map;
import juzu.impl.common.Content;
import juzu.impl.common.MethodInvocation;
import juzu.impl.common.Path;
import juzu.impl.common.Timestamped;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.plugin.template.metamodel.TemplateMetaModel;
import juzu.impl.template.spi.ParseContext;
import juzu.impl.template.spi.Template;
import juzu.impl.template.spi.TemplateException;
import juzu.impl.template.spi.TemplateProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessContext {
    protected final Map<Path, Template<?>> templates;

    public ProcessContext(Map<Path, Template<?>> templates) {
        this.templates = templates;
    }

    protected Timestamped<Content> resolveResource(Path path) {
        return null;
    }

    protected TemplateProvider resolverProvider(String ext) {
        return null;
    }

    public Template resolveTemplate(Path path) {
        return this.resolveTemplate(path, path);
    }

    public <M extends Serializable> Template<? extends M> resolveTemplate(Path originPath, Path path) {
        Template<Object> template = this.templates.get(path);
        if (template == null) {
            Object templateAST;
            Timestamped<Content> content = this.resolveResource(path);
            if (content == null) {
                throw TemplateMetaModel.TEMPLATE_NOT_RESOLVED.failure(path);
            }
            TemplateProvider provider = this.resolverProvider(path.getExt());
            try {
                templateAST = provider.parse(new ParseContext(), content.getObject().getCharSequence());
            }
            catch (TemplateException e) {
                throw TemplateMetaModel.TEMPLATE_SYNTAX_ERROR.failure(path);
            }
            template = new Template(originPath, templateAST, path, content.getTime());
            this.templates.put(path, template);
            try {
                provider.process(this, template);
            }
            catch (TemplateException e) {
                throw TemplateMetaModel.TEMPLATE_VALIDATION_ERROR.failure(path);
            }
        }
        return template;
    }

    public MethodInvocation resolveMethodInvocation(String typeName, String methodName, Map<String, String> parameterMap) throws ProcessingException {
        return null;
    }
}

