/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.filter;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.NoSuchElementException;
import juzu.UndeclaredIOException;
import juzu.impl.common.Content;
import juzu.impl.common.Timestamped;
import juzu.impl.fs.Filter;
import juzu.impl.fs.spi.PathType;
import juzu.impl.fs.spi.ReadFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterFileSystem<P>
extends ReadFileSystem<P> {
    private final ReadFileSystem<P> filtered;
    private final Filter<P> filter;

    public FilterFileSystem(ReadFileSystem<P> filtered, Filter<P> filter) {
        this.filtered = filtered;
        this.filter = filter;
    }

    @Override
    public boolean equals(P left, P right) {
        return this.filtered.equals(left, right);
    }

    @Override
    public P getRoot() throws IOException {
        String name;
        P root = this.filtered.getRoot();
        if (this.filter.acceptDir(root, name = this.filtered.getName(root))) {
            return root;
        }
        throw new IOException("Cannot access root");
    }

    @Override
    public P getChild(P dir, String name) throws IOException {
        P child = this.filtered.getChild(dir, name);
        return child == null ? null : (P)this.get(name, child);
    }

    @Override
    public long getLastModified(P path) throws IOException {
        return this.filtered.getLastModified(path);
    }

    @Override
    public Class<P> getType() {
        return this.filtered.getType();
    }

    @Override
    public String getDescription() {
        return "Filter[" + this.filtered.getDescription() + "]";
    }

    @Override
    public String getName(P path) {
        return this.filtered.getName(path);
    }

    @Override
    public Iterator<P> getChildren(P dir) throws IOException {
        final Iterator<P> i = this.filtered.getChildren(dir);
        return new Iterator<P>(){
            P next;

            @Override
            public boolean hasNext() {
                try {
                    while (this.next == null && i.hasNext()) {
                        Object path = i.next();
                        String name = FilterFileSystem.this.filtered.getName(path);
                        this.next = FilterFileSystem.this.get(name, path);
                    }
                    return this.next != null;
                }
                catch (IOException e) {
                    throw new UndeclaredIOException(e);
                }
            }

            @Override
            public P next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object path = this.next;
                this.next = null;
                return path;
            }

            @Override
            public void remove() {
                throw new UnsupportedClassVersionError();
            }
        };
    }

    @Override
    public PathType typeOf(P path) throws IOException {
        return this.filtered.typeOf(path);
    }

    @Override
    public Timestamped<Content> getContent(P file) throws IOException {
        return this.filtered.getContent(file);
    }

    @Override
    public File getFile(P path) {
        return this.filtered.getFile(path);
    }

    @Override
    public URL getURL(P path) throws NullPointerException, IOException {
        return this.filtered.getURL(path);
    }

    private P get(String name, P child) throws IOException {
        if (this.filtered.isDir(child)) {
            if (this.filter.acceptDir(child, name)) {
                return child;
            }
            return null;
        }
        if (this.filter.acceptFile(child, name)) {
            return child;
        }
        return null;
    }
}

