/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.metamodel.MetaModelPlugin;
import juzu.impl.metamodel.MetaModelState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetaModelProcessor
extends BaseProcessor {
    public static final MessageCode ANNOTATION_UNSUPPORTED = new MessageCode("ANNOTATION_UNSUPPORTED", "The annotation of this element cannot be supported");
    private MetaModelState<?, ?> state;
    private int index;
    private final Logger log = BaseProcessor.getLogger(this.getClass());

    @Override
    protected void doInit(ProcessingContext context) {
        this.log.log("Using processing env " + context.getClass().getName());
        this.index = 0;
    }

    protected abstract Class<? extends MetaModelPlugin<?, ?>> getPluginType();

    protected abstract MetaModel<?, ?> createMetaModel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        block14: {
            if (!roundEnv.errorRaised()) {
                if (roundEnv.processingOver()) {
                    this.log.log("APT processing over");
                    this.log.log("Passivating model");
                    ((MetaModel)this.state.metaModel).prePassivate();
                    ObjectOutputStream out = null;
                    try {
                        FileObject file = this.getContext().createResource((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "juzu", "metamodel.ser", new Element[0]);
                        out = new ObjectOutputStream(file.openOutputStream());
                        out.writeObject(this.state);
                        this.state = null;
                        Object var6_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        Tools.safeClose(out);
                        throw throwable;
                    }
                    Tools.safeClose(out);
                    {
                        break block14;
                        catch (Exception e) {
                            e.printStackTrace();
                            this.log.log("Could not passivate model ", e);
                            Object var6_10 = null;
                            Tools.safeClose(out);
                            break block14;
                        }
                    }
                }
                this.log.log("Starting APT round #" + this.index);
                if (this.state == null) {
                    block15: {
                        Object var8_15;
                        InputStream in = null;
                        try {
                            FileObject file = this.getContext().getResource(StandardLocation.SOURCE_OUTPUT, "juzu", "metamodel.ser");
                            in = file.openInputStream();
                            ObjectInputStream ois = new ObjectInputStream(in);
                            this.state = (MetaModelState)ois.readObject();
                            this.log.log("Loaded model from " + file.toUri());
                            var8_15 = null;
                        }
                        catch (Throwable throwable) {
                            Object var8_16 = null;
                            Tools.safeClose(in);
                            throw throwable;
                        }
                        Tools.safeClose(in);
                        {
                            break block15;
                            catch (Exception e) {
                                this.log.log("Created new meta model");
                                MetaModelState metaModel = new MetaModelState(this.getPluginType(), this.createMetaModel());
                                metaModel.init(this.getContext());
                                this.state = metaModel;
                                var8_15 = null;
                                Tools.safeClose(in);
                            }
                        }
                    }
                    this.log.log("Activating model");
                    ((MetaModel)this.state.metaModel).postActivate(this.getContext());
                }
                LinkedHashMap<AnnotationKey, AnnotationState> updates = new LinkedHashMap<AnnotationKey, AnnotationState>();
                Set<Class<Annotation>> abc = ((MetaModel)this.state.metaModel).getSupportedAnnotations();
                for (Class<Annotation> annotationType : abc) {
                    TypeElement annotationElt = this.getContext().getTypeElement(annotationType.getName());
                    this.log.log("Processing elements for annotation for " + annotationElt.getQualifiedName());
                    for (Element annotatedElt : roundEnv.getElementsAnnotatedWith(annotationElt)) {
                        if (annotatedElt.getAnnotation(Generated.class) != null) continue;
                        this.log.log("Processing element " + annotatedElt);
                        for (AnnotationMirror annotationMirror : annotatedElt.getAnnotationMirrors()) {
                            if (!((Object)annotationMirror.getAnnotationType().asElement()).equals(annotationElt)) continue;
                            AnnotationKey key = new AnnotationKey(annotatedElt, Name.parse(((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString()));
                            AnnotationState state = AnnotationState.create(annotationMirror);
                            updates.put(key, state);
                        }
                    }
                }
                this.log.log("Process annotations");
                this.state.context.processAnnotations(updates.entrySet());
                this.log.log("Post processing model");
                ((MetaModel)this.state.metaModel).postProcessAnnotations();
                this.log.log("Process events");
                ((MetaModel)this.state.metaModel).processEvents();
                this.log.log("Post process events");
                ((MetaModel)this.state.metaModel).postProcessEvents();
                this.log.log("Ending APT round #" + this.index++);
            }
        }
    }
}

