/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.template.metamodel;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Generated;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import juzu.Path;
import juzu.impl.common.FileKey;
import juzu.impl.common.Logger;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.compiler.BaseProcessor;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.template.TemplatePlugin;
import juzu.impl.plugin.template.metadata.TemplateDescriptor;
import juzu.impl.plugin.template.metamodel.ModelTemplateProcessContext;
import juzu.impl.plugin.template.metamodel.TemplateMetaModel;
import juzu.impl.plugin.template.metamodel.TemplateMetaModelPlugin;
import juzu.impl.plugin.template.metamodel.TemplateRefMetaModel;
import juzu.impl.plugin.template.metamodel.TemplatesMetaModel;
import juzu.impl.template.spi.EmitContext;
import juzu.impl.template.spi.TemplateProvider;
import juzu.template.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateResolver
implements Serializable {
    private static final Logger log = BaseProcessor.getLogger(TemplateResolver.class);
    private final ApplicationMetaModel application;
    private Map<juzu.impl.common.Path, juzu.impl.template.spi.Template<?>> templates;
    private Set<juzu.impl.common.Path> emitted;
    private Map<FileKey, FileObject> stubCache;
    private Map<FileKey, FileObject> classCache;

    public TemplateResolver(ApplicationMetaModel application) {
        if (application == null) {
            throw new NullPointerException();
        }
        this.application = application;
        this.templates = new HashMap();
        this.emitted = new HashSet<juzu.impl.common.Path>();
        this.stubCache = new HashMap<FileKey, FileObject>();
        this.classCache = new HashMap<FileKey, FileObject>();
    }

    public Collection<juzu.impl.template.spi.Template<?>> getTemplates() {
        return this.templates.values();
    }

    public void removeTemplate(juzu.impl.common.Path path) {
        this.templates.remove(path);
    }

    public void prePassivate() {
        log.log("Evicting cache " + this.emitted);
        this.emitted.clear();
        this.stubCache.clear();
        this.classCache.clear();
    }

    public void process(TemplateMetaModelPlugin plugin, ProcessingContext context) throws ProcessingException {
        TemplatesMetaModel metaModel = this.application.getChild(TemplatesMetaModel.KEY);
        log.log("Synchronizing existing templates " + this.templates.keySet());
        Iterator<juzu.impl.template.spi.Template<?>> i = this.templates.values().iterator();
        while (i.hasNext()) {
            juzu.impl.template.spi.Template<?> template = i.next();
            FileKey fileKey = metaModel.resolve(template.getPath());
            FileObject resource = context.resolveResource(this.application.getHandle(), fileKey);
            if (resource == null) {
                i.remove();
                log.log("Detected template removal " + template.getPath());
                continue;
            }
            if (resource.getLastModified() > template.getLastModified()) {
                i.remove();
                log.log("Detected stale template " + template.getPath());
                continue;
            }
            log.log("Template " + template.getPath() + " is valid");
        }
        log.log("Building missing templates");
        HashMap copy = new HashMap(this.templates);
        for (TemplateMetaModel templateMetaModel : metaModel) {
            juzu.impl.template.spi.Template template = (juzu.impl.template.spi.Template)copy.get(templateMetaModel.getPath());
            if (template != null) continue;
            log.log("Compiling template " + templateMetaModel.getPath());
            ModelTemplateProcessContext compiler = new ModelTemplateProcessContext(templateMetaModel, new HashMap(copy), context);
            Collection<juzu.impl.template.spi.Template<?>> resolved = compiler.resolve(templateMetaModel);
            for (juzu.impl.template.spi.Template template2 : resolved) {
                copy.put(template2.getPath(), template2);
            }
        }
        this.templates = copy;
        for (juzu.impl.template.spi.Template template : this.templates.values()) {
            juzu.impl.common.Path originPath = template.getOriginPath();
            TemplateMetaModel templateMeta = metaModel.get(originPath);
            LinkedHashSet<Name> types = new LinkedHashSet<Name>();
            for (TemplateRefMetaModel templateRefMetaModel : templateMeta.getRefs()) {
                ElementHandle.Field handle = templateRefMetaModel.getHandle();
                types.add(handle.getFQN());
            }
            Element[] elements = new Element[types.size()];
            boolean bl = false;
            for (Name type : types) {
                elements[++var11_18] = context.getTypeElement(type.getIdentifier());
            }
            this.resolveStub(template, plugin, context, elements);
            this.resolvedQualified(template, context, elements);
            this.resolveScript(template, plugin, context, elements);
        }
    }

    private <M extends Serializable> void resolveScript(final juzu.impl.template.spi.Template<M> template, final TemplateMetaModelPlugin plugin, final ProcessingContext context, final Element[] elements) {
        context.executeWithin(elements[0], new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                TemplatesMetaModel metaModel = TemplateResolver.this.application.getChild(TemplatesMetaModel.KEY);
                TemplateProvider provider = plugin.providers.get(template.getPath().getExt());
                if (!TemplateResolver.this.emitted.contains(template.getPath())) {
                    try {
                        Object model = template.getModel();
                        EmitContext emitCtx = new EmitContext();
                        CharSequence res = provider.emit(emitCtx, model);
                        if (res != null) {
                            FileKey absolute = metaModel.resolve(template.getPath().as(provider.getTargetExtension()));
                            FileObject scriptFile = context.createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, absolute, elements);
                            Writer writer = null;
                            try {
                                writer = scriptFile.openWriter();
                                writer.write(((Object)res).toString());
                            }
                            finally {
                                Tools.safeClose(writer);
                            }
                            log.log("Generated template script " + template.getPath() + " as " + scriptFile.toUri() + " with originating elements " + Arrays.asList(elements));
                        }
                        TemplateResolver.this.emitted.add(template.getPath());
                    }
                    catch (IOException e) {
                        throw TemplateMetaModel.CANNOT_WRITE_TEMPLATE_SCRIPT.failure(e, template.getPath());
                    }
                }
                log.log("Template " + template.getPath() + " was found in cache");
                return null;
            }
        });
    }

    private <M extends Serializable> void resolvedQualified(juzu.impl.template.spi.Template<M> template, ProcessingContext context, Element[] elements) {
        juzu.impl.common.Path path;
        TemplatesMetaModel metaModel = this.application.getChild(TemplatesMetaModel.KEY);
        FileKey absolute = metaModel.resolve(path = template.getPath());
        if (this.classCache.containsKey(absolute)) {
            log.log("Template class " + path + " was found in cache");
            return;
        }
        Writer writer = null;
        try {
            JavaFileObject classFile = context.createSourceFile(absolute.fqn, elements);
            writer = classFile.openWriter();
            writer.append("package ").append(absolute.packageFQN).append(";\n");
            writer.append("import ").append(TemplateDescriptor.class.getCanonicalName()).append(";\n");
            writer.append("import ").append(TemplatePlugin.class.getCanonicalName()).append(";\n");
            writer.append("@").append(Generated.class.getName()).append("({})\n");
            writer.append("@").append(Path.class.getName()).append("(\"").append(path.getValue()).append("\")\n");
            writer.append("public class ").append(path.getRawName()).append(" extends ").append(Template.class.getName()).append("\n");
            writer.append("{\n");
            writer.append("@javax.inject.Inject\n");
            writer.append("public ").append(path.getRawName()).append("(").append(TemplatePlugin.class.getSimpleName()).append(" templatePlugin").append(")\n");
            writer.append("{\n");
            writer.append("super(templatePlugin, \"").append(path.getValue()).append("\");\n");
            writer.append("}\n");
            writer.append("public static final ").append(TemplateDescriptor.class.getName()).append(" DESCRIPTOR = new ").append(TemplateDescriptor.class.getName()).append("(").append(absolute.fqn).append(".class);\n");
            String baseBuilderName = Template.Builder.class.getCanonicalName();
            if (template.getParameters() != null) {
                writer.append("public Builder with() {\n");
                writer.append("return new Builder();\n");
                writer.append("}\n");
                writer.append("public class Builder extends ").append(baseBuilderName).append("\n");
                writer.append("{\n");
                for (String paramName : template.getParameters()) {
                    writer.append("public Builder ").append(paramName).append("(Object ").append(paramName).append(") {\n");
                    writer.append("set(\"").append(paramName).append("\",").append(paramName).append(");\n");
                    writer.append("return this;\n");
                    writer.append("}\n");
                }
                writer.append("}\n");
            } else {
                writer.append("public ").append(baseBuilderName).append(" with() {\n");
                writer.append("return new ").append(baseBuilderName).append("();\n");
                writer.append("}\n");
            }
            writer.append("}\n");
            this.classCache.put(absolute, classFile);
            log.log("Generated template class " + path + " as " + classFile.toUri() + " with originating elements " + Arrays.asList(elements));
        }
        catch (IOException e) {
            try {
                throw TemplateMetaModel.CANNOT_WRITE_TEMPLATE_CLASS.failure(e, elements[0], path);
            }
            catch (Throwable throwable) {
                Tools.safeClose(writer);
                throw throwable;
            }
        }
        Tools.safeClose(writer);
    }

    private void resolveStub(juzu.impl.template.spi.Template<?> template, TemplateMetaModelPlugin plugin, ProcessingContext context, Element[] elements) {
        TemplatesMetaModel metaModel = this.application.getChild(TemplatesMetaModel.KEY);
        FileKey absolute = metaModel.resolve(template.getPath());
        if (this.stubCache.containsKey(absolute)) {
            log.log("Template strub " + template.getPath() + " was found in cache");
            return;
        }
        Name stubFQN = Name.parse(absolute.fqn + "_");
        TemplateProvider provider = plugin.providers.get(template.getPath().getExt());
        Writer writer = null;
        try {
            JavaFileObject stubFile = context.createSourceFile(stubFQN, elements);
            writer = stubFile.openWriter();
            writer.append("package ").append(stubFQN.getParent()).append(";\n");
            writer.append("import ").append(Generated.class.getCanonicalName()).append(";\n");
            writer.append("@Generated({\"").append(stubFQN).append("\"})\n");
            writer.append("public class ").append(stubFQN.getIdentifier()).append(" extends ").append(provider.getTemplateStubType().getName()).append(" {\n");
            writer.append("}");
            this.stubCache.put(absolute, stubFile);
            log.log("Generating template stub " + stubFQN + " as " + stubFile.toUri() + " with originating elements " + Arrays.asList(elements));
        }
        catch (IOException e) {
            try {
                throw TemplateMetaModel.CANNOT_WRITE_TEMPLATE_STUB.failure(e, elements[0], template.getPath());
            }
            catch (Throwable throwable) {
                Tools.safeClose(writer);
                throw throwable;
            }
        }
        Tools.safeClose(writer);
    }
}

